#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# $GTK_PARADISE/examples/gtk3/036_revealer_example.rb
# =========================================================================== #
require 'gtk3'

class RevealerExample < ::Gtk::Window

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    super()
    signal_connect(:destroy) { Gtk.main_quit }

    grid = Gtk::Grid.new
    add(grid)

    @revealer = Gtk::Revealer.new
    @revealer.set_reveal_child(true)
    grid.attach(@revealer, 0, 0, 1, 1)
    grid.set_border_width(5)

    label = Gtk::Label.new('Label in a Revealer')
    @revealer.add(label)

    button = Gtk::Button.new(label: 'Hide')
    button.signal_connect(:clicked) {
      on_reveal_clicked(button)
      _ = button.label.to_s
      case _
      when /Hide/
        button.set_label('Reveal')
      when /Reveal/
        button.set_label('Hide')
      end
    }
    grid.attach(button, 0, 1, 1, 1)
  end

  # ========================================================================= #
  # === on_reveal_clicked
  # ========================================================================= #
  def on_reveal_clicked(button)
    reveal = @revealer.reveal_child?
    @revealer.set_reveal_child(!reveal)
  end

end

if __FILE__ == $PROGRAM_NAME
  window = RevealerExample.new
  window.show_all
  window.move(0, 0)
  window.set_border_width(8)
  Gtk.main  
end