#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::HelloWorld
# =========================================================================== #
# $GTK_PARADISE/examples/gtk3/016_hello_world_in_gtk3_and_bold_font.rb
# =========================================================================== #
require 'gtk3'

module Gtk

class HelloWorld < ::Gtk::Box

  alias e puts

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      run_already = true
    )
    super(:horizontal)
    set_size_request(300, 100)
    set_border_width(10)
    # set_icon_from_file('/Depot/j/foo.png') # <- You could specify a fav-icon too.
    run if run_already
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    button = ::Gtk::Button.new(label: 'Say hello')
    button.signal_connect(:clicked) {
      e 'Hello World!! \\o/'
    }
    button.override_font(
      Pango::FontDescription.new('bold') # Make it bold here.
    )
    add(button)
  end

end; end

if __FILE__ == $PROGRAM_NAME
  window = Gtk::Window.new
  hello_world = Gtk::HelloWorld.new
  window.add(hello_world)
  window.signal_connect(:delete_event) { |_widget| ::Gtk.main_quit }
  window.show_all
  window.move(0, 0)
  ::Gtk.main
end