#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# $GTK_PARADISE/examples/gtk3/notebook_example.rb
# =========================================================================== #
require 'gtk3'

alias e puts

@counter = 4

Gtk::Settings.default.gtk_font_name = 'Sans 22'

window = Gtk::Window.new
# =========================================================================== #
# Create the gtk-notebook next:
# =========================================================================== #
@notebook = Gtk::Notebook.new
@notebook.set_show_tabs(true)
@notebook.set_show_border(true)
@notebook.set_scrollable(true)
@notebook.set_tab_pos(:right) # This is just to demonstrate how this is done.    

# =========================================================================== #
# === add_a_tab
# =========================================================================== #
def add_a_tab(
    widget_to_add = ::Gtk::Button.new(label: 'A new button'),
    text_to_use   = 'Tab '+@counter.to_s
  )
  widget_to_add.signal_connect(:clicked) {
    e 'I was clicked - '+text_to_use
  }
  @notebook.append_page(widget_to_add, ::Gtk::Label.new(text_to_use))
  @notebook.set_tab_reorderable(widget_to_add, true)
  @notebook.show_all
  @counter += 1
end

button_add_a_tab = Gtk::Button.new(label: 'Add a tab')
button_add_a_tab.signal_connect(:clicked) {
  e 'Adding a new tab next.'
  add_a_tab
}

find_button = Gtk::Button.new(label: 'Test')
find_button.signal_connect(:clicked) { e 'Test' }
find_button.show

@notebook.append_page(find_button, ::Gtk::Label.new('Tab 1'))

cancel_button = Gtk::Button.new(label: 'Cancel')
cancel_button.signal_connect(:clicked) { e 'Test' }
cancel_button.show
@notebook.append_page(cancel_button, ::Gtk::Label.new('Tab 2'))

test_button = Gtk::Button.new(label: 'Test')
@notebook.append_page(test_button, ::Gtk::Label.new('Tab 3'))

test_button = Gtk::Button.new(label: 'Test')
@notebook.append_page(test_button, ::Gtk::Label.new('Tab 4'))

@notebook.set_tab_reorderable(find_button,   true)
@notebook.set_tab_reorderable(cancel_button, true)
@notebook.set_tab_reorderable(test_button,   true)
@notebook.page = 1
@notebook.signal_connect(:switch_page) {|widget, event|
  puts 'page is switch'
  pp @notebook.page
  true
}
# pp @notebook.methods.sort # For debugging purposes.

vbox = Gtk::Box.new(:vertical)
vbox.pack_start(button_add_a_tab, expand: true, fill: false)
vbox.pack_start(@notebook, expand: true, fill: true)
window.add(vbox)
window.show_all
window.move(0, 0)
window.set_size_request(1000, 800)
window.signal_connect(:delete_event) { Gtk.main_quit }
Gtk.main