#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# $GTK_PARADISE/examples/gtk3/010_switch_example.rb
# =========================================================================== #
require 'gtk3'

window = Gtk::Window.new
window.set_size_request(120, 150)
window.title = 'Switch Widgets'
window.border_width = 4
vbox = Gtk::Box.new(:vertical)
vbox.pack_start(
  switch1 = Gtk::Switch.new,
  expand: false,
  fill:   false
)
vbox.pack_start(
  switch2 = Gtk::Switch.new,
  expand: false,
  fill:   false
)
vbox.pack_start(
  switch3 = Gtk::Switch.new,
  expand: false,
  fill:   false
)
array_switches = []
array_switches << switch1
array_switches << switch2
array_switches << switch3

def on_switch_activated(switch)
  state = switch.active? ? 'on' : 'off'
  puts "Switch was turned #{state}"
end

array_switches.each {|switch|
  switch.signal_connect('notify::active') { |entry|
    on_switch_activated(entry)
  }
}

array_switches.each {|switch|
  switch.set_hexpand(false)
  switch.set_vexpand(false)
  switch.set_size_request(42, 18)
}

window.add(vbox)
window.move(0, 0)
window.show_all
window.signal_connect(:destroy){ Gtk.main_quit }
Gtk.main