#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk3'
window = Gtk::Window.new('Pointer grab/ungrab sample')

watch_cursor = Gdk::Cursor.new(:watch)
button1 = Gtk::Button.new(label: 'Grab Window!')
button2 = Gtk::Button.new(label: 'Ungrab Window!')

button1.signal_connect(:clicked) {
  Gdk.pointer_grab(window.window, true, 
    :button_press_mask, 
    window.window, 
    watch_cursor,
    Gdk::CURRENT_TIME
  )
  p Gdk.pointer_is_grabbed?
}

button2.signal_connect(:clicked) {
  Gdk.pointer_ungrab(Gdk::CURRENT_TIME)
  p Gdk.pointer_is_grabbed?
}

window.add(Gtk::Box.new(:vertical).add(button1).add(button2))
window.set_default_size(300, 150).show_all
window.signal_connect(:destroy) { Gtk.main_quit }
Gtk.main
# $RUBY_GTK/pointer_grab.rb