#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk3'

class RubyApp < Gtk::Window

  alias e puts

  # ========================================================================= #
  # === USE_THIS_IMAGE
  # ========================================================================= #
  USE_THIS_IMAGE = File.absolute_path("#{__dir__}/..")+
                   '/../images/misc/sample_image.png'

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      run_already = true
    )
    super()
    reset
    set_title 'Fixed'
    run if run_already
  end

  # ========================================================================= #
  # === reset
  # ========================================================================= #
  def reset
    set_default_size(400, 340)
    signal_connect(:destroy) { Gtk.main_quit }
  end

  # ========================================================================= #
  # === create_skeleton
  # ========================================================================= #
  def create_skeleton
    # deprecated -> modify_bg Gtk::STATE_NORMAL, Gdk::Color.new(6400, 6400, 6440) 
    # override_background_color = :normal, Gdk::Color.new(6400, 6400, 6440)
    begin
      bardejov = GdkPixbuf::Pixbuf.new(file: USE_THIS_IMAGE)
      rotunda  = GdkPixbuf::Pixbuf.new(file: USE_THIS_IMAGE)
      mincol   = GdkPixbuf::Pixbuf.new(file: USE_THIS_IMAGE)
    rescue IOError => error
      e error
      e 'cannot load images'
      exit
    end
    image1 = Gtk::Image.new(pixbuf: bardejov)
    image2 = Gtk::Image.new(pixbuf: rotunda)
    image3 = Gtk::Image.new(pixbuf: mincol)

    fixed = Gtk::Fixed.new
    # Designate where these images should be, in the fixed-widget.
    fixed.put(image1,  20,  20)
    fixed.put(image2,  40, 160)
    fixed.put(image3, 170,  50)
    add(fixed)
    move(0, 0)
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    create_skeleton
    show_all
  end

end

if __FILE__ == $PROGRAM_NAME
  RubyApp.new.move(0, 0)
  Gtk.main
end # fixed_example.rb