#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This widget will show some information about the font in use.
# =========================================================================== #
# $GTK_PARADISE/examples/gtk3/font_related_information.rb
# =========================================================================== #
require 'gtk3'

module Gtk

class FontRelatedInformation < ::Gtk::Window # === Gtk::FontRelatedInformation

  alias e puts

  begin
    require 'colours/html_colours'
    include Colours
  rescue LoadError; end

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = Pango::FontDescription.new('Hack 25')

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      run_already = true
    )
    super('First example')
    reset
    override_font(USE_THIS_FONT)
    run if run_already
  end

  # ========================================================================= #
  # === reset
  # ========================================================================= #
  def reset
    # ======================================================================= #
    # === @use_this_font
    # ======================================================================= #
    @use_this_font = 'Hack 20'
    set_size_request(400, 400)
    set_border_width(10)
  end

  # ========================================================================= #
  # === display_the_full_font_of
  # ========================================================================= #
  def display_the_full_font_of(
      font_description
    )
    e 'The font description, as String, is: '+
      ::Colours.steelblue(font_description.to_s)
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    button = ::Gtk::Button.new(label: 'Say hello')
    button.signal_connect(:clicked) {
      e 'Hello World!! \\o/'
      pango_context = button.pango_context
      font_description = pango_context.font_description
      display_the_full_font_of(font_description)
      e 'The family name is: '+steelblue(font_description.family.to_s)
      splitted = @use_this_font.split(' ')
      @use_this_font = splitted.first+' '+(splitted.last.to_i+1).to_s
      button.override_font(
        Pango::FontDescription.new(
          @use_this_font
        )
      )
      button.override_font(Pango::FontDescription.new('bold'))
    }
    button.override_font(
      Pango::FontDescription.new('bold')
    )
    add(button)
    signal_connect(:delete_event) { |_widget| ::Gtk.main_quit }
    show_all
    move(0, 0)
    ::Gtk.main
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::FontRelatedInformation.new
end