#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'radio_menu_item_showcase.rb'
# =========================================================================== #
# $GTK_PARADISE/examples/gtk3/radio_menu_item_example.rb
# =========================================================================== #
require 'gtk3'

module Gtk

class RadioMenuItemShowcase < ::Gtk::Box # === Gtk::RadioMenuItemShowcase

  alias e puts

  # ========================================================================= #
  # == initialize
  # ========================================================================= #
  def initialize(
      run_already = true
    )
    super(:vertical)
    run if run_already
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    # ======================================================================= #
    # Create the menubar
    # ======================================================================= #
    menubar = Gtk::MenuBar.new
    pack_start(menubar, expand: false, fill: false, padding: 0)
    # ======================================================================= #
    # Create our toplevel menuitem next:
    # ======================================================================= #
    top_menu = Gtk::MenuItem.new(
      label: 'The Root Menu (click on it)',
      use_underline: false
    )
    # ======================================================================= #
    # Append the top_menu into the menubar:
    # ======================================================================= #
    menubar.append(top_menu)
    # ======================================================================= #
    # Create an empty menu to hold all of our menuitems
    # ======================================================================= #
    menu = Gtk::Menu.new
    # ======================================================================= #
    # Create radio menus    
    # ======================================================================= #
    first  = Gtk::RadioMenuItem.new(nil,   'First')
    second = Gtk::RadioMenuItem.new(first, 'Second')
    third  = Gtk::RadioMenuItem.new(first, 'Third')

    menu.append(first)
    menu.append(second)
    menu.append(third)
    # Connect signals to the radio menu items:
    first.signal_connect(:activate)  { e "First was activated!"  }
    second.signal_connect(:activate) { e "Second was activated!" }
    third.signal_connect(:activate)  { e "Third was activated!"  }
    top_menu.set_submenu(menu)
  end

end; end

if __FILE__ == $PROGRAM_NAME
  puts 'Gtk::RadioMenuItem will be demonstrated next.'
  _ = Gtk::RadioMenuItemShowcase.new
  window = Gtk::Window.new
  window.add(_)
  window.show_all
  window.set_size_request(600, 600)
  window.move(0, 0)
  Gtk.main
end # rb radio_menu_item_showcase.rb