#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# $GTK_PARADISE/examples/gtk3/002_scrolled_window_example.rb
# =========================================================================== #
require 'gtk3'

alias e puts

window = Gtk::Window.new

@text_buffer = Gtk::TextBuffer.new

@text_view = Gtk::TextView.new(@text_buffer)
@text_view.set_editable(true)
rgba = Gdk::RGBA.new
rgba.parse(:lightblue)

@text_view.override_background_color(:normal, rgba)
@text_view.cursor_visible = false # cursor is nit mehr zu sehen.
@text_view.wrap_mode = :word
@text_view.left_margin  = 25
@text_view.right_margin = 25
@text_view.set_cursor_visible(true)

@scrolled_window = Gtk::ScrolledWindow.new
@scrolled_window.add_with_viewport(@text_view)
@scrolled_window.set_policy(:always, :always)
@scrolled_window.signal_connect(:event) {|widget, event|
  _ = event.event_type.name.to_s
  case _
  when 'GDK_SCROLL' # Respond to scroll-events next.
    e 'The widget received a scroll-event (:scroll_event).'
    value = widget.vadjustment
    e value
    # vadj.set_value(ypos-80) 
    # self.scrolled_window.set_vadjustment(vadj)
  when 'GDK_BUTTON_PRESS'
    e 'The left mouse-button was clicked! Selecting everything next.'
    @text_view.signal_emit(:select_all, event)
  end
}

window.add(@scrolled_window)
window.show_all
window.set_size_request(1200, 800)
window.set_border_width(25)
window.move(0, 0)
window.signal_connect(:delete_event) { ::Gtk.main_quit }
Gtk.main