#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# $GTK_PARADISE/examples/gtk4/010_switch_example.rb
# =========================================================================== #
require 'gtk4'

application = Gtk::Application.new('org.gtk.switch_example', :flags_none)

def on_switch_activated(switch)
  state = switch.active? ? 'on' : 'off'
  puts "Switch was turned #{state}"
end

application.signal_connect(:activate) { |app|
  win = Gtk::ApplicationWindow.new(app)
  win.title = 'Switch Widgets'
  win.set_default_size(120, 600)
  
  vbox = Gtk::Box.new(:vertical)
  vbox.prepend(
    switch1 = Gtk::Switch.new
  )
  vbox.prepend(
    switch2 = Gtk::Switch.new
  )
  vbox.prepend(
    switch3 = Gtk::Switch.new
  )

  array_switches = []
  array_switches << switch1
  array_switches << switch2
  array_switches << switch3
  
  array_switches.each {|switch|
    switch.signal_connect('notify::active') { |entry|
      on_switch_activated(entry)
    }
  }
  array_switches.each {|switch|
    switch.set_hexpand(false)
    switch.set_vexpand(false)
    switch.set_size_request(42, 18)
  }
  win.set_child(vbox)
  win.show
  win.set_size_request(200, 800)
}

application.run