#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::SearchBarExample
#
# This shows how to use the modern search-bar. This also currently does
# not work; it works in ruby-gtk3 though.
# =========================================================================== #
# require 'gtk_paradise/examples/gtk4/008_search_bar_example.rb'
# Gtk::SearchBarExample.new
# =========================================================================== #
# $GTK_PARADISE/examples/gtk4/008_search_bar_example.rb
# =========================================================================== #
require 'gtk4'

module Gtk

class SearchBarExample < ::Gtk::Box

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    super(:horizontal)
    reset
    run
  end

  # ========================================================================= #
  # === searchbar?
  # ========================================================================= #
  def searchbar?
    @searchbar
  end

  # ========================================================================= #
  # === reset
  # ========================================================================= #
  def reset
    @searchbar = ::Gtk::SearchBar.new
  end

  # ========================================================================= #
  # === on_key_event
  #
  # Cause the searchbar to show up.
  # ========================================================================= #
  def on_key_event(widget, event)
    shortcut = ::Gtk.accelerator_get_label(event.keyval, event.state)
    # ======================================================================= #
    # Get support for Ctrl+F next:
    # ======================================================================= #
    if ['Ctrl+F', 'Ctrl+Mod2+F'].include? shortcut
      if @searchbar.search_mode?
        @searchbar.set_search_mode(false)
      else
        @searchbar.set_search_mode(true)
      end
    end
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    label = ::Gtk::Label.new('Press Control+F to initiate find')
    grid = ::Gtk::Grid.new
    grid.attach(label, 0, 0, 1, 1)
    grid.attach(@searchbar, 0, 1, 1, 1)

    @searchentry = ::Gtk::SearchEntry.new
    @searchbar.connect_entry(@searchentry)
    @searchbar.set_child(@searchentry)
    append(grid)
  end

end; end

application = Gtk::Application.new('org.gtk.search_bar_example', :flags_none)
application.signal_connect(:activate) { |app|
  win = ::Gtk::ApplicationWindow.new(app)
  win.title = 'Search Bar Example' 
  win.set_default_size(800, 800)
  win.set_child(Gtk::SearchBarExample.new)
  win.show
}
application.run