#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk4'

alias e puts

application = Gtk::Application.new('org.gtk.simple_dialog_example', :flags_none)
application.signal_connect(:activate) { |app|
  win = Gtk::ApplicationWindow.new(app)
  win.title = 'Showcasing Gtk Dialog' 
  win.set_default_size(420, 600)

  dialog = Gtk::Dialog.new

  dialog.add_button(
    Gtk::Image.new(path: '/home/x/data/images/misc/INDEX_FAVICON.png'), :yes
  )
  dialog.add_button(
    Gtk::Image.new(path: '/home/x/data/images/misc/LINKS_FAVICON.png'),  :no
  )
  dialog.set_size_request(800, 800)
  label = Gtk::Label.new('Do you like GTK?')
  label.show
  dialog.child.pack_start(label)
  response = dialog.run
  dialog.destroy
  case response
  when Gtk::ResponseType::YES
    e 'The user selected yes.'
  when Gtk::ResponseType::NO
    e 'The user selected no.'
  else
    e 'The user selected something else.'
  end
  #win.set_child(dialog)
  win.show
}

application.run