#!/usr/bin/env ruby
require 'gtk_paradise/require_gtk4'

class TestWidget < Gtk::Box

  alias e puts

  include ::Gtk::BaseModule

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      run_already = true
    )
    super(:vertical)
    run if run_already
  end

  # ========================================================================= #
  # === title?
  # ========================================================================= #
  def title?
    'Test Widget'
  end; alias title title? # === title

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    use_these_css_rules = Gtk.css_rules?.to_s
    use_these_css_rules << '
    .bblack1 { border: 1px solid black; }
    .mar8px { margin: 8px; }
    .tomato {
      color: tomato;
    }
    .BG_green {
      background-color: green;
    }
    .bold_font {
      font-weight: 500;
    }
    .larger_font {
      font-size: 5em;
    }
    .button_with_fancy_hover_effect:hover {
      background-color: lightblue;
    }

    '+Gtk.return_gtk_paradise_css_rules
    button = button('Hello world!')
    button.clear_background
    ::Gtk.load_css_engine_for_gtk4(
      use_these_css_rules
    )
    button.css_class('mar8px')
    button.bblack3
    button.css_class('tomato')
    button.css_class('BG_green')
    button.make_bold
    button.css_class('larger_font')
    # button.on_hover(:lightblue)
    button.on_hover(:gold)
    # ^^^
    button.on_clicked {
      e "Hello World"
      # application_window.destroy
    }
    append(button) # set_child(button)
    append(
      text('Add textview and style another button
      also add all CSS rules')
    )
    append(
      ::Gtk::TextView.new
    )
    append(
      text('Und das ist ... ?')
    )
    append(
      toggle_button('123')
    )
  end

end

if __FILE__ == $PROGRAM_NAME
  Gtk.default_application('interactive.caesar.cipher') {{
    widget_to_use: TestWidget.new
  }}  
end