#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# Extensions to the Gdk module will be collected here.
# =========================================================================== #
# require 'gtk_paradise/gdk/screen.rb'
# =========================================================================== #
module Gdk

class Screen # === Gdk::Screen

  require 'gtk_paradise/gdk/cursor.rb'

  # ========================================================================= #
  # === Gdk::Screen.width_height
  #
  # Return both width and height, in Array form.
  # ========================================================================= #
  def self.width_height
    [ Gdk::Screen.default.width, Gdk::Screen.default.height ]
  end

end; end

if __FILE__ == $PROGRAM_NAME
  require 'gtk3'
  pp Gdk::Screen.width_height
end