#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Pango::Layout
#
# Extend the pango layout.
#
# Pango::SCALE was 1024 when I checked it during October 2008. It still is
# in 2020. :)
# =========================================================================== #
# require 'gtk_paradise/pango/layout.rb'
# =========================================================================== #
module Pango

class Layout # === Pango::Layout

  require 'gtk_paradise/pango/pango_fonts.rb'

  # ========================================================================= #
  # === size_points
  # ========================================================================= #
  def size_points
    self.size.map { |entry| entry / Pango::SCALE }
  end

  # ========================================================================= #
  # === width_points
  # ========================================================================= #
  def width_points
    self.size[0] / Pango::SCALE
  end

  # ========================================================================= #
  # === height_points
  # ========================================================================= #
  def height_points
    self.size[1] / Pango::SCALE
  end

  # ========================================================================= #
  # === width_points=
  # ========================================================================= #
  def width_points=(width)
    self.width = width * Pango::SCALE
  end

end; end