#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === FoobarParadise::GUI::Gtk::GtkStandalone
# =========================================================================== #
# require 'foobar/gui/gtk3/prototypes/unified_gtk_prototype.rb'
# FoobarParadise::GUI::Gtk::GtkStandalone.run
# =========================================================================== #
_ = ARGV.first
if _.nil? or _.empty?
  _ = 'gtk3' # This is the default.
end
case _
when /gtk2/
  require 'gtk_paradise/require_gtk2'
when /gtk3/
  require 'gtk_paradise/require_gtk3'
when /gtk4/
  require 'gtk_paradise/require_gtk4'
end

module FoobarParadise

module GUI

module Gtk

class GtkStandalone < ::Gtk::Box # === FoobarParadise::GUI::Gtk::GtkStandalone 

  include ::Gtk::BaseModule

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Pick a proper title here please.'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = '25% or minimum 200px'

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = '15% or minimum 100px'

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = :dejavu_condensed_20

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = ARGV,
      run_already           = true
    )
    super(:vertical)
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    populate_the_internal_hash_with_the_default_values
    # reset_the_shared_module
    infer_the_namespace
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, namespace?]
    # ======================================================================= #
    # === Set the title, width, height and the font in use.
    # ======================================================================= #
    title_width_height_font(TITLE, WIDTH, HEIGHT, USE_THIS_FONT)
    use_gtk_paradise_project_css_file # or use use_project_css_file 
    infer_the_size_automatically
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    4
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    2
  end

  # ========================================================================= #
  # === create_skeleton                            (create tag, skeleton tag)
  # ========================================================================= #
  def create_skeleton
    # create_the_entries
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    abort_on_exception
    minimal(
      left_aligned_label('Installer')
    )
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    super()
  end

  # ========================================================================= #
  # === FoobarParadise::GUI::Gtk::GtkStandalone.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
  end

  # ========================================================================= #
  # === FoobarParadise::GUI::Gtk::GtkStandalone.run_gtk2
  # ========================================================================= #
  def self.run_gtk2
  end

  # ========================================================================= #
  # === FoobarParadise::GUI::Gtk::GtkStandalone.run_gtk3
  # ========================================================================= #
  def self.run_gtk3(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = ::FoobarParadise::GUI::Gtk::GtkStandalone.new(i)
    r = ::Gtk.run
    r << _
    r.automatic_size_then_automatic_title
    r.enable_quick_exit
    r.top_left_then_run
  end

  # ========================================================================= #
  # === FoobarParadise::GUI::Gtk::GtkStandalone.run_gtk4
  # ========================================================================= #
  def self.run_gtk4
    ::Gtk.default_application('unified.gtk.prototype') {{
      widget_to_use: FoobarParadise::GUI::Gtk::GtkStandalone.new
    }}
  end

end; end; end; end

if __FILE__ == $PROGRAM_NAME
  _ = ARGV.first
  if _.nil? or _.empty?
    _ = 'gtk3' # This is the default.
  end
  case _
  when /gtk2/
    FoobarParadise::GUI::Gtk::GtkStandalone.run_gtk2
  when /gtk3/
    FoobarParadise::GUI::Gtk::GtkStandalone.run_gtk3
  when /gtk4/
    FoobarParadise::GUI::Gtk::GtkStandalone.run_gtk4
  end
end # rb unified_gtk_prototype.rb