#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'gtk_paradise/run'
# =========================================================================== #
require 'gtk_paradise/run/run.rb'

if __FILE__ == $PROGRAM_NAME
  alias e puts
  # ========================================================================= #
  # Use some test-code to test Gtk.run quickly.
  # ========================================================================= #
  foo = Gtk.button('_Foo')
  r = Gtk.run
  r << foo
  r.show_all
  r.top_left
  r.feedback
  r.fancy_title('Hey there 📶')
  r.width_height(800, 680)
  e ::Colours.rev+'The screen-resolution for this computer is: '
  pp r.resolution?
  r.run
end # $GTK_PARADISE/run.rb

# ==================================================================== #
# === Usage Example
#
# Complete usage example for this class follows next:
# ==================================================================== #
#
#   require 'gtk_paradise/run'
#
#   if __FILE__ == $PROGRAM_NAME
#     x = RandomImage.new
#     r = Gtk.run('80%','50%',
#       :tabble,
#       'Name',2 
#     )
#     r << x
#     r.show_all
#     r.add_shortcut(1, 'focus(:left)', :alt)
#     r.modify_background(:normal, :grey)
#     r.top_left_then_run
#   end
#