#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'gtk_paradise/toplevel_methods/events.rb'
# =========================================================================== #
module Gtk

  # ========================================================================= #
  # === Gtk.scroll_up_event?
  # ========================================================================= #
  def self.scroll_up_event?(event)
    case event.class.to_s
    # ======================================================================= #
    # === Gdk::EventScroll
    # ======================================================================= #
    when 'Gdk::EventScroll'
      direction = event.direction
      if direction == Gdk::ScrollDirection::UP
        return true
      end
    end
    return false
  end

  # ========================================================================= #
  # === Gtk.scroll_down_event?
  # ========================================================================= #
  def self.scroll_down_event?(event)
    case event.class.to_s
    # ======================================================================= #
    # === Gdk::EventScroll
    # ======================================================================= #
    when 'Gdk::EventScroll'
      direction = event.direction
      if direction == Gdk::ScrollDirection::DOWN
        return true
      end
    end
    return false
  end

  # ========================================================================= #
  # === Gtk.event_left_mouse_button_click?
  #
  # The ruby-gtk2 name may be:
  #
  #   event.event_type == Gdk::Event::BUTTON_PRESS
  #
  # But I think checking via .name is better.
  # ========================================================================= #
  def self.event_left_mouse_button_click?(event)
    event.is_a?(Gdk::EventButton) and
   (event.event_type.name == 'GDK_BUTTON_PRESS') and
   (event.button == 1)
  end; self.instance_eval { alias left_mouse_button_clicked? event_left_mouse_button_click? } # === Gtk.left_mouse_button_clicked?

  # ========================================================================= #
  # === Gtk.event_middle_mouse_button_click?
  # ========================================================================= #
  def self.event_middle_mouse_button_click?(event)
    event.is_a?(Gdk::EventButton) and
   (event.event_type.name == 'GDK_BUTTON_PRESS') and
   (event.button == 2)
  end; self.instance_eval { alias middle_mouse_button_clicked? event_middle_mouse_button_click? } # === Gtk.middle_mouse_button_clicked?

  # ========================================================================= #
  # === Gtk.event_right_mouse_button_click?
  #
  # This method queries whether the right mouse-button was clicked.
  # ========================================================================= #
  def self.event_right_mouse_button_click?(event)
    event.is_a?(Gdk::EventButton) and
   (event.event_type.name == 'GDK_BUTTON_PRESS') and
   (event.button == 3)
  end; self.instance_eval { alias right_mouse_button_clicked? event_right_mouse_button_click? } # === Gtk.right_mouse_button_clicked?

end