#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'gtk_paradise/toplevel_methods/screen_resolution.rb'
# Gtk.resolution?
# =========================================================================== #
module Gtk

  require 'gtk_paradise/toplevel_methods/determine_which_gtk_version_is_in_use.rb'

  # ========================================================================= #
  # === Gtk.resolution?
  #
  # Query the resolution of the target computer, via Gdk::Screen
  # related methods. This will return the max-width and max-height
  # value, respectively.
  #
  # Note that this method will work both with ruby-gtk2 and with ruby-gtk3.
  #
  # An Array will be returned by this method, such as [1920, 1080].
  # ========================================================================= #
  def self.resolution?
    # ======================================================================= #
    # The following code has been commented out on 14.09.2022 - the new code
    # appears to work on ruby-gtk3 and ruby-gtk4 just fine. If we ever need
    # to support ruby-gtk2 then we may have to adjust the code - but for
    # now this shall suffice. 
    # ======================================================================= #
    # if use_gtk3?
    #   _ = Gdk::Screen.default
    #   return [_.width, _.height]
    # elsif use_gtk4?
    #   width  = Gdk::Display.default.primary_monitor.geometry.width
    #   height = Gdk::Display.default.primary_monitor.geometry.height
    #   return [width, height]
    # else # else assume something simply for gtk4.
    #   return [1800, 1200]
    # end
    # In September 2022 this was modified a bit, for ruby-gtk2 support.
    # In November 2023 this was removed again. Quite a story. \o/
    # if ::Gtk.use_gtk2?
    #   _ = Gdk::Screen.default
    #   return [_.width, _.height]
    # else
      width  = Gdk::Display.default.primary_monitor.geometry.width
      height = Gdk::Display.default.primary_monitor.geometry.height
      return [width, height]
    # end
  end; self.instance_eval { alias screen_resolution? resolution? } # === Gtk.screen_resolution?

  # ========================================================================= #
  # === Gtk.max_width?
  #
  # This is functionally equivalent to Gdk::Screen.default.width(),
  # at the least for ruby-gtk3. In ruby-gtk4 this has changed a
  # little.
  # ========================================================================= #
  def self.max_width?
    resolution?.first
  end

  # ========================================================================= #
  # === Gtk.max_height?
  # ========================================================================= #
  def self.max_height?
    resolution?.last
  end

end

if __FILE__ == $PROGRAM_NAME
  require 'gtk4' # or 'gtk3'
  pp Gtk.resolution? # => [2560, 1080]
end