#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::GenerateGtkPrototype
#
# Usage example:
#
#   Gtk::GenerateGtkPrototype.new(ARGV)
#
# =========================================================================== #
# require 'gtk_paradise/utility_scripts/generate_gtk_prototype.rb'
# =========================================================================== #
module Gtk

class GenerateGtkPrototype # === Gtk::GenerateGtkPrototype

  require 'fileutils'

  begin
    require 'save_file'
  rescue LoadError; end

  alias e puts

  require 'gtk_paradise/base_module/internal_hash_module/internal_hash_module.rb'
  include ::Gtk::InternalHashModule

  # ========================================================================= #
  # === PROTOTYPE_DIRECTORY
  # ========================================================================= #
  PROTOTYPE_DIRECTORY =
    '/home/x/programming/ruby/src/gtk_paradise/lib/gtk_paradise/prototypes/'

  # ========================================================================= #
  # === FILE_SHARED_CODE
  # ========================================================================= #
  FILE_SHARED_CODE = PROTOTYPE_DIRECTORY+'shared_code.rb'

  # ========================================================================= #
  # === FILE_GTK3_PROTOTYPE
  # ========================================================================= #
  FILE_GTK3_PROTOTYPE =
    PROTOTYPE_DIRECTORY+'gtk3_prototype.rb'

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = nil,
      run_already           = true
    )
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_hash
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    name_to_use = first?.to_s.dup
    if name_to_use.end_with? '.rb'
      name_to_use.delete_suffix!('.rb')
    end
    FileUtils.mkdir(name_to_use) unless File.directory? name_to_use
    # ======================================================================= #
    # Read in the shared-code next.
    # ======================================================================= #
    dataset1 = File.read(FILE_SHARED_CODE)
    SaveFile.write_what_into(dataset1, name_to_use+'_module.rb')
    dataset2 = File.read(FILE_GTK3_PROTOTYPE)
    SaveFile.write_what_into(dataset2, 'gtk3.rb')
    # ======================================================================= #
    # Rename it to the new name.
    # ======================================================================= #
    new_name = name_to_use+'.rb'
    e 'Renaming to '+new_name+' next.'
    rename_this_file('gtk3.rb', to: new_name)
    if File.directory?(name_to_use) and File.file?(name_to_use+'_module.rb')
      e 'Moving the file '+name_to_use+'_module.rb next.'
      target = name_to_use+'/'+name_to_use+'_module.rb'
      FileUtils.mv(
        name_to_use+'_module.rb',
        target
      )
      esystem "bluefish #{target} &"
    end
  end

  # ========================================================================= #
  # === rename_this_file
  # ========================================================================= #
  def rename_this_file(
      old = 'gtk3.rb', to: new_name
    )
    if to.is_a? Hash
      to = to[:to]
    end
    FileUtils.mv(old, to)
  end

  # ========================================================================= #
  # === Gtk::GenerateGtkPrototype[]
  # ========================================================================= #
  def self.[](i = ARGV)
    new(i)
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::GenerateGtkPrototype.new(ARGV)
end # generategtkprototype