#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'gtk_paradise/classes/cell_renderer_progress_example.rb'
# =========================================================================== #
require 'gtk_paradise/require_gtk2'

module Gtk

class CellRendererProgressExample < Gtk::VBox # === Gtk::CellRendererProgressExample

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  # ========================================================================= #
  # === DELAY
  # ========================================================================= #
  DELAY = 0.05

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    super()
    register_sigint
    reset
    run
  end

  # ========================================================================= #
  # === reset
  # ========================================================================= #
  def reset
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, NAMESPACE]
    set_font_size(18)
  end

  # ========================================================================= #
  # === connect_skeleton
  # ========================================================================= #
  def connect_skeleton
    list_store = ::Gtk::ListStore.new(String, Float)
    tree_view = ::Gtk.tree_view(list_store)
    prog = list_store.append
    prog[0] = 'ONE'
    prog[1] = 30
    prog1 = list_store.append
    prog1[0] = 'TWO'
    prog1[1] = 5
    prog2 = list_store.append
    prog2[0] = 'THREE'
    prog2[1] = 10
    renderer = ::Gtk.cell_renderer_text
    acol = Gtk::TreeViewColumn.new('words', renderer, :text  => 0)
    tree_view.append_column(acol)
    cell_renderer_progress = ::Gtk::CellRendererProgress.new
    pcol = ::Gtk::TreeViewColumn.new('Progress', cell_renderer_progress, value: 1)
    tree_view.append_column(pcol)
    dir = 1
    Thread.new {
      loop {
        # auffi mit dir
        prog2[1] += dir
        if prog2[1] > 100
          prog2[1] = 100
          dir = - dir
        end
        # obi mit dir
        if prog2[1] < 0
          prog2[1] = 0
          dir = - dir
        end
        # schlafi mit dir
        sleep DELAY
      }
    }
    pack_minimal(
      gtk_bold_label('TreeView: CellRendererProgressExample')
    )
    add(tree_view)
    show_all
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    connect_skeleton
  end

end; end

if __FILE__ == $PROGRAM_NAME
  require 'gtk_paradise/run.rb'
  r = Gtk.run
  r << Gtk::CellRendererProgressExample.new
  r.enable_quick_exit
  r.top_left_then_run
end # cellrendererprogressexample