#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::CursorExamples
#
# Usage example:
#
#   Gtk::CursorExamples.new
#
# =========================================================================== #
# require 'gtk_paradise/widgets/gtk2/cursor_examples.rb'
# =========================================================================== #
require 'gtk_paradise/require_gtk2'

module Gtk

class CursorExamples < ::Gtk::HBox # === Gtk::CursorExamples

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  # ========================================================================= #
  # === NAMESPACE
  # ========================================================================= #
  NAMESPACE = inspect

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = nil,
      run_already           = true
    )
    super()
    reset
    register_sigint
    set_commandline_arguments(
      commandline_arguments
    )
    @gdk_cursor = Gdk::Cursor.new(Gdk::Cursor::LEFT_PTR)
    create_the_click_button
    cursors = Gdk::Cursor::Type.values - [Gdk::Cursor::CURSOR_IS_PIXMAP]
    counter = 0
    # ======================================================================= #
    # Add the click-button that can respond to mouse-click events:
    # ======================================================================= #
    @click_button.signal_connect(:clicked) {
      cursor = cursors[counter]
      p cursor.inspect
      @click_button.set_label(cursor.inspect)
      @gdk_cursor = Gdk::Cursor.new(cursor)
      window?.window.set_cursor(@gdk_cursor)
      counter += 1
      counter = 0 if counter == cursors.size
    }
    add(@click_button)
    button2 = gtk_button('Click!')
    button2.signal_connect(:event) { |widget, event|
      case event.event_type.name
      when 'GDK_ENTER_NOTIFY'
        window?.window.set_cursor(Gdk::Cursor.new(Gdk::Cursor::BOAT))
      when 'GDK_LEAVE_NOTIFY'
        window?.window.set_cursor(Gdk::Cursor.new(Gdk::Cursor::LEFT_PTR))
      end
    }
    add(button2)
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, NAMESPACE]
  end

  # ========================================================================= #
  # === window?
  #
  # We will assume that the @commandline_arguments hold the parent widget.
  # ========================================================================= #
  def window?
    @commandline_arguments.first
  end

  # ========================================================================= #
  # === create_the_click_button
  # ========================================================================= #
  def create_the_click_button
    @click_button = gtk_button('Click!')
    @click_button.use_underline = false
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
  end

  # ========================================================================= #
  # === Gtk::CursorExamples[]
  # ========================================================================= #
  def self.[](i = '')
    new(i)
  end

end; end

if __FILE__ == $PROGRAM_NAME
  require 'gtk_paradise/run.rb'
  r = Gtk.run
  r.width = 400
  r.height = 180
  r << Gtk::CursorExamples.new(r)
  r.enable_quick_exit
  r.top_left_then_run
end # cursor_examples