#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::EmojiToggleWidget
#
# This widget can be used to toggle the state between two emojis.
#
# Usage example:
#
#   Gtk::EmojiToggleWidget.new(ARGV)
#
# =========================================================================== #
# require 'gtk_paradise/classes/gtk2/emoji_toggle_widget/emoji_toggle_widget.rb'
# Gtk::EmojiToggleWidget.new(ARGV)
# =========================================================================== #
require 'gtk_paradise/require_gtk2'

module Gtk

class EmojiToggleWidget < ::Gtk::Label

  require 'gtk_paradise/widgets/shared_code/emoji_toggle_widget/emoji_toggle_widget_module.rb'
  include Gtk::EmojiToggleWidgetModule

  # ========================================================================= #
  # === Gtk::EmojiToggleWidget.run
  # ========================================================================= #
  def self.run
    ::Gtk::EmojiToggleWidgetModule.run
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::EmojiToggleWidget.run
end # EmojiToggleWidget