#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::Gtksourceview2Example
# =========================================================================== #
# This file is similar to the file in
# 'gtk_paradise/examples/gtksourceview2_example.rb', but it will make use
# of BaseModule, and less code, too.
# =========================================================================== #
# require 'gtk_paradise/classes/gtksourceview2_example.rb'
# Gtk::Gtksourceview2Example.new
# =========================================================================== #
require 'gtk_paradise/require_gtk2'

module Gtk

class Gtksourceview2Example < ::Gtk::VBox

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  require 'gtk_paradise/gtk_classes/source_view.rb'

  begin
    require 'gtksourceview2'
  rescue LoadError; end

  # ========================================================================= #
  # === NAMESPACE
  # ========================================================================= #
  NAMESPACE = inspect

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Gtksourceview2-Example'

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(run_already = true)
    super()
    reset
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, NAMESPACE]
    # ======================================================================= #
    # === @title
    # ======================================================================= #
    @title = TITLE
    increase_font_size
  end

  # ========================================================================= #
  # === create_skeleton
  # ========================================================================= #
  def create_skeleton
    # ======================================================================= #
    # Add a Gtk::SourceView instance next, before setting up some sane
    # defaults.
    # ======================================================================= #
    source_view = ::Gtk::SourceView.new # gtk_source_view# { :do_use_sane_defaults }
    if source_view.respond_to? :show_line_numbers
      source_view.show_line_numbers = true
      source_view.insert_spaces_instead_of_tabs = true
      source_view.indent_width = 2
      source_view.show_right_margin = true
      source_view.right_margin_position = 80
    end
    # source_view.buffer.do_use_ruby
    source_view.buffer.language = ::Gtk::SourceLanguageManager.new.get_language('ruby')
    source_view.buffer.highlight_syntax = true
    source_view.buffer.highlight_matching_brackets = true
    source_view.buffer.set_text "class Foobar\n  # this is an example class\nend\n"
    add(
      gtk_scrolled_window(source_view)
    )
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    create_skeleton
  end

end; end

if __FILE__ == $PROGRAM_NAME
  require 'gtk_paradise/run'
  r = Gtk.run
  _ = Gtk::Gtksourceview2Example.new
  r << _
  r.enable_simple_exit
  r.top_left_then_run
end