#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::HboxExample
# =========================================================================== #
require 'gtk_paradise/require_gtk2'

module Gtk

class HboxExample < ::Gtk::HBox # === Gtk::HboxExample

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  # ========================================================================= #
  # === HboxExample::MAX_HEIGHT
  # ========================================================================= #
  MAX_HEIGHT = 600

  # ========================================================================= #
  # === HboxExample::MAX_WIDTH
  # ========================================================================= #
  MAX_WIDTH  = 380

  # ========================================================================= #
  # === PADDING_TO_USE_FOR_THIS_WIDGET
  # ========================================================================= #
  PADDING_TO_USE_FOR_THIS_WIDGET = 30

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(run_already = true)
    super(true, PADDING_TO_USE_FOR_THIS_WIDGET)
    reset
    register_sigint
    set_size_request(MAX_HEIGHT, MAX_WIDTH)
    run if run_already
  end

  # ========================================================================= #
  # === reset
  # ========================================================================= #
  def reset
    infer_the_namespace
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, NAMESPACE]
    e 'Our HBox will be padded ('+PADDING_TO_USE_FOR_THIS_WIDGET.to_s+')'
  end

  # ========================================================================= #
  # === create_hbox
  # ========================================================================= #
  def create_hbox
    @button_quit = gtk_button('_Quit')
    @button_quit.on_clicked { Gtk.main_quit }
    @button_quat = gtk_button('Quat')
    @button_quat.on_clicked { Gtk.main_quit }
    add(@button_quit).add(@button_quat)
    show_all
  end

  # ========================================================================= #
  # === connect_skeleton
  # ========================================================================= #
  def connect_skeleton
    create_hbox
  end

  # ========================================================================= #
  # === recommended_total_width?
  # ========================================================================= #
  def recommended_total_width?
    MAX_WIDTH
  end

  # ========================================================================= #
  # === recommended_total_height?
  # ========================================================================= #
  def recommended_total_height?
    MAX_HEIGHT
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    connect_skeleton
  end

end; end

if __FILE__ == $PROGRAM_NAME
  require 'gtk_paradise/run'
  demo_of_labels = Gtk::HboxExample.new
  r = Gtk.run(
    demo_of_labels.recommended_total_width?,
    demo_of_labels.recommended_total_height?,
    :tabble_picture,
    'Showcasing Gtk::HBox',2 
  )
  r << demo_of_labels
  r.modify_background(:normal, :white)
  r.show_all
  r.enable_quick_exit
  r.top_left_then_run
end # hbox_example.rb