#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'gtk_paradise/classes/keyboard_grab.rb'
# =========================================================================== #
require 'gtk_paradise/require_gtk2'

module Gtk

class Keyboard < ::Gtk::VBox

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  begin
    require 'colours'
  rescue LoadError; end

  # =========================================================================== #
  # === initialize
  # =========================================================================== #
  def initialize
    super()
    button1 = gtk_button('Grab Keyboard!')
    button2 = gtk_button('Ungrab Keyboard!')
    add(button1)
    add(button2)
    button1.on_clicked {
      do_grab_the_keyboard(self)
    }
    button2.on_clicked {
      e Gdk::Event::CURRENT_TIME
      do_ungrab_the_keyboard
    }
    reset
  end

  # =========================================================================== #
  # === reset
  # =========================================================================== #
  def reset
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, inspect]
  end
  
  # =========================================================================== #
  # === do_grab_the_keyboard
  #
  # This will "redirect" the keyboard input into that widget. Personally
  # I don't quite like this, as it is fairly intrusive.
  # =========================================================================== #
  def do_grab_the_keyboard(i)
    Gdk.keyboard_grab(i.window, true, Gdk::Event::CURRENT_TIME)
  end

  # =========================================================================== #
  # === do_ungrab_the_keyboard
  # =========================================================================== #
  def do_ungrab_the_keyboard
    Gdk.keyboard_ungrab(Gdk::Event::CURRENT_TIME)
  end

end; end

if __FILE__ == $PROGRAM_NAME
  require 'colours/colours_e_autoinclude.rb'
  e 'This widget will grab the keyboard.'
  require 'gtk_paradise/run.rb'
  r = Gtk.run('80%','50%',
        :tabble,
        'Keyboard Grabber', 2
      )
  r << Gtk::Keyboard.new
  r.modify_background :default, :grey
  r.add_shortcut(1, 'focus(:left)', :alt)
  r.enable_quick_exit
  r.top_left_then_show_all_then_run
end # gtk_keyboard_grab