#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# Showcases how do to multiple selects in a tree-view widget. You need to
# press the control-key while doing the selection.
# =========================================================================== #
require 'gtk_paradise/require_gtk2'

module Gtk

class MultipleSelectInATreeViewWidget < Gtk::HBox # === Gtk::MultipleSelectInATreeViewWidget

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    super()
    register_sigint
    reset
    create_gtk_tree_view
    prev_selected = []
    selected = []
    @tree_view.selection.signal_connect(:changed) { |selection|
      prev_selected, selected = selected, selection.selected_rows
      false
    }
    @tree_view.signal_connect(:row_activated) { |widget, path, column|
      p prev_selected
      false
    }
    column = ::Gtk::TreeViewColumn.new(
      'column', ::Gtk::CellRendererText.new, 'text' => 0
    )
    @tree_view.append_column(column)
    populate_the_model
    connect_skeleton
  end

  # ========================================================================= #
  # === reset
  # ========================================================================= #
  def reset
    infer_the_namespace
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, namespace?]
    @model = ::Gtk::TreeStore.new(String)
  end

  # ========================================================================= #
  # === create_gtk_tree_view
  # ========================================================================= #
  def create_gtk_tree_view
    @tree_view = Gtk.tree_view
    @tree_view.model = @model
    # ======================================================================= #
    # The next line of code enables multiple select, which essentially
    # invokes .selection.mode = ::Gtk::SELECTION_MULTIPLE
    # ======================================================================= #
    @tree_view.enable_selection_multiple
  end

  # ========================================================================= #
  # === populate_the_model
  #
  # This method will add the various values from 0 up to 12.
  # ========================================================================= #
  def populate_the_model(n_times = 12)
    n_times.times { |entry|
      iter = @model.append(nil)
      iter.set_value(0, entry.to_s)
    }
  end

  # ========================================================================= #
  # === connect_skeleton
  # ========================================================================= #
  def connect_skeleton
    add(@tree_view)
  end

end; end

if __FILE__ == $PROGRAM_NAME
  require 'gtk_paradise/run.rb'
  r = Gtk.run
  r << Gtk::MultipleSelectInATreeViewWidget.new
  r.enable_simple_exit
  r.top_left_then_run
end # gtk_multiple_select