#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::NotebookTab_ColouredTopBar
#
# This is a Gtk::Notebook tab, with a highlighted top.
# =========================================================================== #
# require 'gtk_paradise/widgets/gtk2/notebook_tab_coloured_top_bar.rb'
# =========================================================================== #
require 'gtk2'

module Gtk

class NotebookTab_ColouredTopBar < Gtk::VBox

  require 'gtk_paradise/widgets/version_agnostic/coloured_unit.rb'

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      img_location = '/home/x/DATA/images/RPG/STD/SMALL_SHIELD.png',
      label_title  = 'test',
      text_colour  = 'darkblue',
      bar_colour   = 'darkorange',
      can_focus    = false
    )
    super(false, 0)
    reset
    # gi $MY_USERS/x/DATA/images/RPG/STD/SMALL_SHIELD.png
    hbox = Gtk::HBox.new(true, 0)
    10.times { |t|
      _ = ColouredUnit.new(bar_colour)
      @array_coloured_units << _ # Append into the Array here.
      hbox.maximal(_,0) 
    }
    maximal(hbox, 0)
    maximal(
      modify_bold_label(label_title, text_colour), 0
    )
    self.can_focus = false
    set_border_width(0)
    show_all
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, inspect]
    # ======================================================================= #
    # === @array_coloured_units
    # ======================================================================= #
    @array_coloured_units = []
  end

  # ========================================================================= #
  # === change_colour
  # ========================================================================= #
  def change_colour(
      to = 'gray'
    )
    @array_coloured_units.each { |entry| entry.change_colour(to) }
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::NotebookTab_ColouredTopBar.new
end