#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtkhex'

module PDFWalker

class Walker < ::Gtk::Window

  private
  # ========================================================================= #
  # === create_hexview
  # ========================================================================= #
  def create_hexview
    @hexview = DumpView.new(self)
  end

  class DumpView < ::Gtk::ScrolledWindow

    require 'gtk_paradise/requires/require_the_base_module.rb'
    include ::Gtk::BaseModule

    # ======================================================================= #
    # === initialize
    # ======================================================================= #
    def initialize(parent)
      @parent = parent
      super()
      # set_policy(POLICY_AUTOMATIC, POLICY_AUTOMATIC)
      automatic_policy
      @current_obj = nil

      @view = HexEditor.new
      @view.show_offsets(true)
      add_with_viewport @view
    end

    # ======================================================================= #
    # === clear
    # ======================================================================= #
    def clear
      @view.set_data ''
    end

    # ======================================================================= #
    # === load
    # ======================================================================= #
    def load(object)
      return if @current_obj.equal?(object)
      self.clear
      case object # case tag
      when Origami::Stream
        load_stream(object)
      when Origami::String
        load_string(object)
      end
      @current_obj = object
    end

    # ======================================================================= #
    # === load_stream
    # ======================================================================= #
    def load_stream(object)
      begin
        @view.set_data(object.data)
      rescue Origami::Filter::Error
        @view.set_data($!.input_data) if $!.input_data
        @parent.error("#{$!.class}: #{$!.message}") unless object.filters == [ :DCTDecode ]
      end
    end; private :load_stream

    # ======================================================================= #
    # === load_string
    # ======================================================================= #
    def load_string(object)
      @view.set_data(object.value)
    end; private :load_string
  end

end; end