#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
module PDFWalker

class ImgViewer < ::Gtk::Window

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  attr_reader :image

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    super()
    set_my_title('Image view')
    set_decorated(false)
    set_resizable(false)
    add_events(Gdk::Event::KEY_RELEASE_MASK)
    signal_connect(:key_release_event) { |_widget, event|
      destroy if event.keyval == Gdk::Keyval::GDK_Escape
    }
  end

  # ========================================================================= #
  # === show_raw_img
  # ========================================================================= #
  def show_raw_img(data, w, h, bpc, bpr)
    set_default_size(w, h)

    pixbuf = GdkPixbuf::Pixbuf.new(
               data: data,
               colorspace: GdkPixbuf::Colorspace::RGB,
               has_alpha: false,
               bits_per_sample: bpc,
               width: w,
               height: h,
               row_stride: bpr
             )
    @image = Gtk::Image.new(pixbuf)
    add(@image)
    show_all
  end

  # ========================================================================= #
  # === show_compressed_img
  # ========================================================================= #
  def show_compressed_img(data)
    loader = GdkPixbuf::PixbufLoader.new
    loader.last_write(data)

    pixbuf = loader.pixbuf
    set_default_size(pixbuf.width, pixbuf.height)
    @image = gtk_image(pixbuf)
    add(@image)
    show_all
  end

end; end