#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
module PDFWalker
  
class Walker < Window

  # ========================================================================= #
  # === show_xrefs
  # ========================================================================= #
  def show_xrefs(target)
    XrefsDialog.new(self, target)
  end

end

class XrefsDialog < Dialog
  
  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  # ========================================================================= #
  # === OBJCOL
  # ========================================================================= #
  OBJCOL  = 0
  REFCOL  = 1
  NAMECOL = 2

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(parent, target)
    super(
      "Xrefs to #{target.reference}",
      parent, Dialog::MODAL, [Stock::CLOSE, Dialog::RESPONSE_NONE]
    )
    @parent = parent

    @list = ListStore.new(Object, String, String)
    @view = TreeView.new(@list)

    column = Gtk::TreeViewColumn.new("Origin", Gtk::CellRendererText.new, text: REFCOL)
    @view.append_column(column)

    column = Gtk::TreeViewColumn.new("Objects", Gtk::CellRendererText.new, text: NAMECOL)
    @view.append_column(column)

    target.xrefs.each { |obj|
      str = obj.type.to_s
      iter = @list.append
      @list.set_value(iter, OBJCOL, obj)
      obj = obj.parent until obj.indirect?
      @list.set_value(iter, REFCOL, obj.reference.to_s)
      @list.set_value(iter, NAMECOL, str)
    }

    @view.signal_connect(:row_activated) { |_tree, _path, _column|
      if @view.selection.selected
        from = @list.get_value(@view.selection.selected, OBJCOL)
        @parent.treeview.goto(from)
      end
    }
    scroll = gtk_scrolled_window(@view) { :always }
    vbox.add(scroll)
    set_default_size(200, 200)
    signal_connect(:response) { destroy }
    show_all
  end

end; end