#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::ReorderableTabsExample
#
# This is just an example how to do reorderable tabs in ruby-gtk.
#
# See also: http://ruby-gnome2.osdn.jp/hiki.cgi?Gtk%3A%3ANotebook
# =========================================================================== #
require 'gtk_paradise/require_gtk2'

module Gtk

class ReorderableTabsExample < ::Gtk::HBox # === Gtk::ReorderableTabsExample

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  # ========================================================================= #
  # === NAMESPACE
  # ========================================================================= #
  NAMESPACE = inspect

  # ========================================================================= #
  # === ReorderableTabsExample::MAX_HEIGHT
  # ========================================================================= #
  MAX_HEIGHT = 800

  # ========================================================================= #
  # === ReorderableTabsExample::MAX_WIDTH
  # ========================================================================= #
  MAX_WIDTH  = 680

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      run_already = true
    )
    super()
    reset
    register_sigint
    set_size_request(MAX_HEIGHT, MAX_WIDTH)
    run if run_already
  end

  # ========================================================================= #
  # === reset
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, NAMESPACE]
  end

  # ========================================================================= #
  # === recommended_total_width?
  # ========================================================================= #
  def recommended_total_width?
    MAX_WIDTH
  end

  # ========================================================================= #
  # === recommended_total_height?
  # ========================================================================= #
  def recommended_total_height?
    MAX_HEIGHT
  end

  # ========================================================================= #
  # === connect_skeleton
  # ========================================================================= #
  def connect_skeleton
    # ======================================================================= #
    # Create the first Notebook:
    # ======================================================================= #
    notebook1 = gtk_notebook
    notebook1.append_page(
      label1 = gtk_label('notebook1 label1').make_bold, gtk_label('notebook1 label2').make_bold
    )
    notebook1.append_page(
      label2 = gtk_label('notebook1 label3').make_bold, gtk_label('notebook1 label4').make_bold
    )
    notebook1.set_tab_reorderable(label1, true)
    notebook1.set_tab_reorderable(label2, true)
    notebook1.set_tab_detachable(label1, true)
    notebook1.set_tab_detachable(label2, true)
    notebook1.set_group_id(0)
    # ======================================================================= #
    # Create the second Notebook
    # ======================================================================= #
    notebook2 = gtk_notebook
    label3 = gtk_label('Right side').make_bold
    notebook2.append_page(
      label3, gtk_label('foo2').make_bold
    )
    notebook2.set_tab_reorderable(label3, true)
    notebook2.append_page(label4 = gtk_label('bar2'), gtk_label('bar2'))
    notebook2.set_tab_reorderable(label4, true)

    label5 = gtk_label('More content side').make_bold
    notebook2.append_page(
      label5, gtk_label('Another tab').make_bold
    )

    notebook2.set_tab_detachable(label3, true)
    notebook2.set_tab_detachable(label4, true)
    notebook2.set_group_id(0)
    maximal(notebook1)
    maximal(notebook2)
    show_all
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    2
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    connect_skeleton
  end

end; end

if __FILE__ == $PROGRAM_NAME
  require 'gtk_paradise/run.rb'
  demo_of_labels = Gtk::ReorderableTabsExample.new
  r = Gtk.run(
    demo_of_labels.recommended_total_width?,
    demo_of_labels.recommended_total_height?,
    :tabble,
    'Notebook' 
  )
  r.set_size_request(800, 800)
  r << demo_of_labels
  r.show_all
  r.modify_background :normal, :white
  r.enable_quick_exit
  r.top_left_then_run
end # gtk_demo_reorderable_tabs