#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::RulerWidget
#
# Usage example:
#
#   Gtk::RulerWidget.new
#
# =========================================================================== #
# require 'gtk_paradise/widgets/ruler_widget.rb'
# =========================================================================== #
require 'gtk_paradise/require_gtk2'

module Gtk

class RulerWidget < ::Gtk::VBox # === Gtk::RulerWidget

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  # ========================================================================= #
  # === NAMESPACE
  # ========================================================================= #
  NAMESPACE = inspect

  # ========================================================================= #
  # === BE_VERBOSE
  # ========================================================================= #
  BE_VERBOSE = false

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = nil,
      run_already           = true
    )
    super()
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    run if run_already
  end
  
  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, NAMESPACE]
    @title = 'RulerWidget'
    @be_verbose = BE_VERBOSE
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    # ======================================================================= #
    # Register the necessary events: pointer-motion-mask
    # ======================================================================= #
    set_events(
      Gdk::Event::POINTER_MOTION_MASK | Gdk::Event::POINTER_MOTION_HINT_MASK
    )
    table = Gtk::Table.new(2, 2, false)

    # ======================================================================= #
    # === Horizontal Ruler
    # ======================================================================= #
    hruler = Gtk::HRuler.new
    hruler.metric = Gtk::CENTIMETERS
    hruler.set_range(100, 0, 0, 20)

    # ======================================================================= #
    # === Vertical Ruler
    # ======================================================================= #
    vruler = gtk_vruler
    vruler.set_range(5, 15, 0, 20)
    
    signal_connect(:motion_notify_event) { |w, e| 
      vruler.signal_emit(:motion_notify_event, e)
      e sfancy('motion_notify_event occurred') if @be_verbose
    }
    signal_connect(:motion_notify_event) { |w, e|
      hruler.signal_emit(:motion_notify_event, e)
      e sfancy('motion_notify_event occurred.') if @be_verbose
    }

    table.attach(hruler, 1, 2, 0, 1,
      Gtk::EXPAND | Gtk::FILL, Gtk::FILL, 0, 0)
    table.attach(vruler, 0, 1, 1, 2,
      Gtk::FILL, Gtk::EXPAND | Gtk::FILL, 0, 0)

    hbox = gtk_hbox
    hbox.minimal(
      gtk_label('Look at the right side → '), 0
    )
    hbox.add(table)
    add(hbox)
  end

  # ========================================================================= #
  # === Gtk::Ruler[]
  # ========================================================================= #
  def self.[](i = '')
    new(i)
  end

end; end

if __FILE__ == $PROGRAM_NAME
  require 'gtk_paradise/run.rb'
  r = Gtk.run(
    800,
    640,
    :tabble_picture,
    __FILE__,2 
  )
  r << Gtk::RulerWidget.new
  r.add_shortcut(1, 'focus(:left)', :alt)
  r.top_left_then_run
end # gtk_ruler