#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::ScaleButtonExample
#
# Usage example:
#
#   Gtk::ScaleButtonExample.new(ARGV)
#
# =========================================================================== #
# require 'gtk_paradise/classes/scale_button_example.rb'
# =========================================================================== #
require 'gtk_paradise/require_gtk2'

module Gtk

class ScaleButtonExample < ::Gtk::HBox # === Gtk::ScaleButtonExample

  include ::Colours

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include Gtk::BaseModule

  # ========================================================================= #
  # === NAMESPACE
  # ========================================================================= #
  NAMESPACE = inspect

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = nil,
      run_already           = true
    )
    super()
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, NAMESPACE]
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    # ======================================================================= #
    # Instantiate a new scale-button next:
    # ======================================================================= #
    scale = gtk_scale_button
    scale.set_icons(
      %w( goto-bottom
          goto-top
          execute
        )
    )
    scale.signal_connect(:value_changed) { |widget, value|
      puts "The value changed: `#{sfancy(value)}`"
    }
    maximal(scale, 2) # Add it here.
    show_all
  end

  # ========================================================================= #
  # === value?
  # ========================================================================= #
  def value?
    scale.value
  end

  # ========================================================================= #
  # === width?
  #
  # The preferred (hardcoded) width. We assume oldschool desktop-computers
  # here.
  # ========================================================================= #
  def width?
    1200
  end

  # ========================================================================= #
  # === Gtk::ScaleButtonExample[]
  # ========================================================================= #
  def self.[](i = '')
    new(i)
  end

  # ========================================================================= #
  # === height?
  # ========================================================================= #
  def height?
    800
  end

end; end

if __FILE__ == $PROGRAM_NAME
  require 'gtk_paradise/run.rb'
  scale_button_example = Gtk::ScaleButtonExample.new
  r = ::Gtk.run
  r << scale_button_example
  r.enable_quick_exit
  r.top_left_then_run
end # scalebuttonexample