#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::Table2
# =========================================================================== #
# require 'gtk_paradise/classes/table2.rb'
# Gtk::Table2.new
# =========================================================================== #
require 'gtk_paradise/require_gtk2'

module Gtk

class Table2 < ::Gtk::VBox

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  begin
    require 'colours'
    include ::Colours
    include ::Colours::E
  rescue LoadError; end

  # ========================================================================= #
  # === ARRAY
  # ========================================================================= #
  ARRAY = %w( hello world this is a great game ! )

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Table2'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = 720

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = 820

  # ========================================================================= #
  # === N
  # ========================================================================= #
  N = "\n"

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      run_already = true
    )
    super(TITLE)
    reset
    run if run_already
  end

  # ========================================================================= #
  # === reset
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    infer_the_namespace
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, namespace?]
    # ======================================================================= #
    # === @width
    # ======================================================================= #
    set_width(WIDTH)
    increase_font_size
  end

  # ========================================================================= #
  # === Table2.width?
  # ========================================================================= #
  def self.width?
    WIDTH
  end

  # ========================================================================= #
  # === Table2.height?
  # ========================================================================= #
  def self.height?
    HEIGHT
  end

  # ========================================================================= #
  # === title?
  # ========================================================================= #
  def title?
    TITLE
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    _ = tree_view_table2(*ARRAY)
    _ = _.first if _.is_a? Array
    add(_)
    show_all
  end

  # ======================================================================== #
  # === run
  # ======================================================================== #
  def run
    connect_skeleton
    show_all
  end

  # ======================================================================== #
  # === Gtk::Shell.run
  #
  # This is the variant that can be "run" directly.
  # ======================================================================== #
  def self.run
    require 'gtk_paradise/run.rb'
    x = Gtk::Table2.new
    r = Gtk.run(
      '80%','72%',
      :tabble
    )
    r.title = x.title? 
    r << x
    r.enable_quick_exit
    r.set_background(:white)
    r.top_left_then_run
  end

end; end

if __FILE__ == $PROGRAM_NAME
  ::Gtk::Table2.run
end # gtktable2