#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This is the cancel-button of the application.
# =========================================================================== #
# require 'gtk_paradise/widgets/gtk2/timer_window/button_cancel.rb'
# =========================================================================== #
require 'gtk_paradise/require_gtk2'

module Gtk

module TimerWindow

class ButtonCancel < ::Gtk::Button

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(text)
    super(text)
    @text = text
    add_click_event
  end

  private
  # ========================================================================= #
  # === add_click_event
  # ========================================================================= #
  def add_click_event
    on_clicked {
      TimerWindow.instance.panel.button_start.cycle_runner.stop
    }
  end

end; end; end