#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::TimerWindow::ButtonStart
#
# This is essentially the start-button.
# =========================================================================== #
# require 'gtk_paradise/classes/gtk2/timer_window/button_start.rb'
# =========================================================================== #
require 'gtk_paradise/widgets/gtk2/timer_window/cycle_runner.rb'
require 'gtk_paradise/widgets/gtk2/timer_window/input_validator.rb'

module Gtk

module TimerWindow

class ButtonStart < Gtk::Button

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(text)
    super(text)
    @text = text
    add_click_event
  end

  # ========================================================================= #
  # === disable
  # ========================================================================= #
  def disable(i)
    self.label = i
    self.sensitive = false
  end

  # ========================================================================= #
  # === enable
  # ========================================================================= #
  def enable
    self.sensitive = true
    self.label = @text
  end

  # ========================================================================= #
  # === cycle_runner?
  # ========================================================================= #
  def cycle_runner?
    @cycle_runner
  end; alias cycle_runner cycle_runner? # === cycle_runner
  
  private
  # ========================================================================= #
  # === add_click_event
  # ========================================================================= #
  def add_click_event
    on_clicked {
      parent_widget = TimerWindow.instance
      cycles = break_time = parent_widget.panel.tf_cycles.text.to_i
      pomodoro_time  = parent_widget.panel.tf_pomodoro.text.to_f
      pomodoro_time *= 60
      pause_time  = parent_widget.panel.tf_pause.text.to_f
      pause_time *= 60 
      break_time  = parent_widget.panel.tf_pause.text.to_f
      break_time *= 60 

      unless InputValidator.validate(pomodoro_time, pause_time, break_time, cycles)
        parent_widget.show_warning_dialog(
          'Please input only valid data for '\
          'the cycle-threshold here.'
        )
      else
        disable 'Running the timer ...'
        @cycle_runner = CycleRunner.new(cycles, pomodoro_time, pause_time, break_time)
        @cycle_runner.run
      end
    }
  end

end; end; end