#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::TimerWindow::CycleRunner
# =========================================================================== #
# require 'gtk_paradise/widgets/gtk2/timer_window/cycle_runner.rb'
# =========================================================================== #
require 'gtk_paradise/widgets/gtk2/timer_window/timer.rb'

module Gtk

module TimerWindow

class CycleRunner

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      n_cycles,
      pomodoro_time,
      pause_time,
      break_time
    )
    @n_cycles       = n_cycles
    @timer_pomodoro = Timer.new(pomodoro_time)
    @timer_pause    = Timer.new(pause_time)
    @timer_break    = Timer.new(break_time)
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    @thread = Thread.new {
      begin
        @n_cycles.times { |i|
          TimerWindow.instance.pop_up
          @timer_pomodoro.run
          if i + 1 != @n_cycles
            TimerWindow.instance.panel.button_start.label = 'Time for a litle pause...'
            TimerWindow.instance.pop_up
            @timer_pause.run
          end
        }
        TimerWindow.instance.panel.button_start.label = 'Now it is time to rest...'
        TimerWindow.instance.pop_up
        @timer_break.run
      rescue => error
        puts error
        Thread.stop
      end
      TimerWindow.instance.pop_up
      TimerWindow.instance.panel.button_start.enable
    }
  end

  # ========================================================================= #
  # === stop
  # ========================================================================= #
  def stop
    @thread.kill
    TimerWindow.instance.panel.button_start.enable
    TimerWindow.instance.panel.progress_bar.text = 'Canceled'
    TimerWindow.instance.panel.progress_bar.fraction = 0
  end

end; end; end