#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::AudioButton
#
# Upon being pressed, this button will play the specified song. The full
# path to the song will be shown.
# =========================================================================== #
# require 'gtk_paradise/widgets/gtk3/audio_button/audio_button.rb'
# _ = Gtk::AudioButton.new(:song33) # This means the 33rd song.
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class AudioButton < ::Gtk::BaseModuleButton # === Gtk::AudioButton

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Play an audio-song'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = '10% or minimum 50px'

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = '8% or minimum 46px'

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = :dejavu_condensed_12

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = ARGV,
      run_already           = true
    )
    super()
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    self.hint = '<b>Click</b> on this button to <b>play</b>.'
    if first?
      set_play_this_song_upon_click_event(first?)
    end
    on_clicked {
      do_play_the_song
    }
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    infer_the_namespace
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, namespace?]
    title_width_height_font(TITLE, WIDTH, HEIGHT, USE_THIS_FONT)
    use_gtk_paradise_project_css_file
    infer_the_size_automatically
    # ======================================================================= #
    # === @connect_to_this_widget
    # ======================================================================= #
    @connect_to_this_widget = nil
    # ======================================================================= #
    # === @play_this_song_upon_click_event
    # ======================================================================= #
    @play_this_song_upon_click_event = nil
  end

  # ========================================================================= #
  # === set_play_this_song_upon_click_event
  # ========================================================================= #
  def set_play_this_song_upon_click_event(i = first?)
    @play_this_song_upon_click_event = i
  end

  # ========================================================================= #
  # === do_play_the_song
  # ========================================================================= #
  def do_play_the_song(
      _ = @play_this_song_upon_click_event
    )
    if _ and File.exist?(_)
      Thread.new {
        esystem "mpv #{_}"
      }
    else
      e "No file exists at #{_}."
    end
  end

  # ========================================================================= #
  # === sync_text
  # ========================================================================= #
  def sync_text
    if @play_this_song_upon_click_event
      set_text(@play_this_song_upon_click_event)
    end
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    sync_text
  end

end; end

if __FILE__ == $PROGRAM_NAME
  require 'gtk_paradise/run'
  r = Gtk.run
  r << Gtk::AudioButton.new
  r.top_left_then_run
end # rb audio_button.rb /home/x/songs/YoungMC_Know_How.mp3