#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'gtk_paradise/widgets/gtk3/drawing_widget.rb'
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class DrawingWidget < ::Gtk::DrawingArea

  # ========================================================================= #
  # === NUMBERS
  #
  # The following numbers will be displayed on the bottom of the widget.
  # ========================================================================= #
  NUMBERS = %w(
    75 150 225 300 375 450 525 600 675
  )

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(parent)
    @parent = parent
    super()
    reset
    run
  end

  # ========================================================================= #
  # === reset
  # ========================================================================= #
  def reset
    # ======================================================================= #
    # === @numbers
    # ======================================================================= #
    @numbers = NUMBERS
    set_size_request(1, 30)
  end

  # ========================================================================= #
  # === on_draw
  # ========================================================================= #
  def on_draw
    cr = window.create_cairo_context
    draw_widget(cr)
  end

  # ========================================================================= #
  # === draw_widget
  # ========================================================================= #
  def draw_widget(cr)
    cr.set_line_width 0.8
    cr.select_font_face('Courier', 
      Cairo::FONT_SLANT_NORMAL,
      Cairo::FONT_WEIGHT_NORMAL
    )
    cr.set_font_size(15)
    width = allocation.width
    @cur_width = @parent.get_cur_value
    step = (width / 10.0).round
    till = (width / 750.0) * @cur_width
    full = (width / 750.0) * 700
    if @cur_width >= 700
      cr.set_source_rgb 1.0, 1.0, 0.72
      cr.rectangle 0, 0, full, 30
      cr.clip
      cr.paint
      cr.reset_clip
      cr.set_source_rgb(1.0, 0.68, 0.68)
      cr.rectangle(full, 0, till-full, 30)
      cr.clip
      cr.paint
      cr.reset_clip
    else
      cr.set_source_rgb(1.0, 1.0, 0.72)
      cr.rectangle(0, 0, till, 30)
      cr.clip
      cr.paint
      cr.reset_clip
    end

    cr.set_source_rgb(0.35, 0.31, 0.24)
    # ======================================================================= #
    # Iterate over the numbers given next.
    # ======================================================================= #
    for i in 1..@numbers.length
      cr.move_to(i*step, 0)
      cr.line_to(i*step, 5)
      cr.stroke
      te = cr.text_extents @numbers[i-1]
      cr.move_to i*step-te.width/2, 15
      cr.text_path(@numbers[i-1])
      cr.stroke
    end     
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    signal_connect(:draw) { on_draw }
  end

end; end