#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::GotoLineWidget
# =========================================================================== #
# require 'gtk_paradise/widgets/gtk3/editor/internal_widgets/goto_line_widget.rb'
# Gtk::GotoLineWidget.new(ARGV)
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class GotoLineWidget < ::Gtk::BaseModuleBox # === Gtk::GotoLineWidget 

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Goto Line Widget'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = '20% or minimum 200px'

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = '12% or minimum 100px'

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = :liberation_serif_14

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = ARGV,
      run_already           = true
    )
    super(:vertical)
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    upon_delete_event_quit_the_application
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    infer_the_namespace
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, namespace?]
    title_width_height_font(TITLE, WIDTH, HEIGHT, USE_THIS_FONT)
    use_gtk_paradise_project_css_file 
    infer_the_size_automatically
    # ======================================================================= #
    # === @connect_to_this_text_buffer
    # ======================================================================= #
    @connect_to_this_text_buffer = nil
    # ======================================================================= #
    # === @parent_widget
    # ======================================================================= #
    @parent_widget = nil
    # ======================================================================= #
    # === @runner_widget
    # ======================================================================= #
    @runner_widget = nil
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    0
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    0
  end

  # ========================================================================= #
  # === reset_the_main_entry
  # ========================================================================= #
  def reset_the_main_entry
    @entry_for_the_line_number.clear
  end

  # ========================================================================= #
  # === connect_to_this_text_buffer
  #
  # This method can be used to specifically connect to a text-buffer.
  # ========================================================================= #
  def connect_to_this_text_buffer(i)
    @text_buffer = i
  end

  # ========================================================================= #
  # === do_the_default_actions
  # ========================================================================= #
  def do_the_default_actions
    if @parent_widget
      # ===================================================================== #
      # Now that we have the number we will jump to that specific position.
      # ===================================================================== #
      @parent_widget.go_to_a_specific_line(which_line?)
      @parent_widget.do_focus
    end
    reset_the_main_entry
    @runner_widget.hide if @runner_widget
  end; alias run_the_go_button do_the_default_actions # === run_the_go_button

  # ========================================================================= #
  # === runner_widget?
  # ========================================================================= #
  def runner_widget?
    @runner_widget
  end; alias runner_widget runner_widget? # === runner_widget

  # ========================================================================= #
  # === set_runner_widget
  # ========================================================================= #
  def set_runner_widget(i)
    @runner_widget = i
  end

  # ========================================================================= #
  # === entry_text?
  # ========================================================================= #
  def entry_text?
    @entry_for_the_line_number.text?
  end

  # ========================================================================= #
  # === which_line?
  #
  # Query the line where we should go to. This defaults to 0 due to
  # ''.to_i returning 0.
  # ========================================================================= #
  def which_line?
    entry_text?.to_i
  end; alias line? which_line? # === line?

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    abort_on_exception

    hbox1 = gtk_hbox
    hbox1.minimal(text('Line number:'), 5)
    @entry_for_the_line_number = entry
    @entry_for_the_line_number.on_enter {
      run_the_go_button
    }
    hbox1.minimal(@entry_for_the_line_number, 5)
    minimal(hbox1)

    hbox2 = gtk_hbox
    button = button('Ok')
    button.on_clicked {
      do_the_default_actions
    }
    hbox2.pack_end(button)
    minimal(hbox2)
  end

  # ========================================================================= #
  # === create_skeleton                                          (create tag)
  # ========================================================================= #
  def create_skeleton
  end

  # ========================================================================= #
  # === set_parent_widget
  # ========================================================================= #
  def set_parent_widget(i)
    @parent_widget = i
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    super()
  end

  # ========================================================================= #
  # === Gtk::GotoLineWidget.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = ::Gtk::GotoLineWidget.new(i)
    r = ::Gtk.run
    r.title = 'Goto Line'
    r << _
    r.automatic_size_then_automatic_title
    r.top_left_then_run
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::GotoLineWidget.run
end