#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::FlexibleVte
# =========================================================================== #
# require 'gtk_paradise/widgets/gtk3/flexible_vte/flexible_vte.rb'
# Gtk::FlexibleVte.run
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class FlexibleVte < ::Gtk::BaseModuleBox

  begin
    require 'vte3'
  rescue LoaderError; end
  require 'gtk_paradise/gtk_classes/vte.rb'

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Flexible VTE'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = 1400

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = 800

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = 'Monospace 16'

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = ARGV,
      run_already           = true
    )
    super(:horizontal)
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    if block_given?
      yielded = yield
      if yielded.is_a? Hash
        # =================================================================== #
        # === :n_tabs
        # =================================================================== #
        if yielded.has_key? :n_tabs
          set_create_n_tabs(yielded[:n_tabs])
        end
      end
    end
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    infer_the_namespace
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, namespace?]
    title_width_height_font(TITLE, WIDTH, HEIGHT, USE_THIS_FONT)
    use_gtk_paradise_project_css_file 
    # ======================================================================= #
    # === @create_n_tabs
    #
    # Determine how many tabs to create.
    # ======================================================================= #
    @create_n_tabs = 10
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    2
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    2
  end

  # ========================================================================= #
  # === set_create_n_tabs
  # ========================================================================= #
  def set_create_n_tabs(i)
    @create_n_tabs = i
  end

  # ========================================================================= #
  # === create_skeleton                                          (create tag)
  # ========================================================================= #
  def create_skeleton
    create_notebook
    create_the_vte_terminal
  end

  # ========================================================================= #
  # === return_a_new_scrollbar
  # ========================================================================= #
  def return_a_new_scrollbar(
      use_this_terminal = @terminal
    )
    scrollbar = gtk_scrollbar(:vertical, use_this_terminal.vadjustment)
    scrollbar.name = 'Flexible VTE scrollbar'
    return scrollbar
  end

  # ========================================================================= #
  # === return_a_new_vte_terminal_instance
  # ========================================================================= #
  def return_a_new_vte_terminal_instance
    terminal = vte_terminal
    terminal.spawn
    terminal.set_font(Pango::FontDescription.new(USE_THIS_FONT))
    terminal.signal_connect(:window_title_changed) { |_widget|
      e 'The new terminal title could be set to: '+
         terminal.window_title
    }
    return terminal
  end

  # ========================================================================= #
  # === create_notebook
  # ========================================================================= #
  def create_notebook
    @notebook = gtk_notebook(:useful_default)
    # ======================================================================= #
    # Enable special CSS rules for that notebook.
    # ======================================================================= #
    @notebook.css_class('notebook1')
  end

  # ========================================================================= #
  # === focus_on_tab_number
  # ========================================================================= #
  def focus_on_tab_number(i = 0)
    @notebook.focus_on_tab_number(i.to_i-1)
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    abort_on_exception
    outer_vbox = gtk_vbox
    outer_vbox.minimal(
      gtk_left_aligned_label('<b>VTE Widget</b>')
    )
    outer_vbox.maximal(@notebook)
    maximal(outer_vbox)
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    super()
  end

  # ========================================================================= #
  # === create_the_vte_terminal
  # ========================================================================= #
  def create_the_vte_terminal
    @create_n_tabs.times { |index|
      hbox = create_hbox
      terminal = return_a_new_vte_terminal_instance
      terminal.signal_connect(:child_exited) {
        @notebook.remove_tab(index)  
      }
      hbox.maximal(terminal)
      hbox.minimal(return_a_new_scrollbar(terminal))
      @notebook.add_tab(hbox, 'Tab #'+(index+1).to_s)
    }
  end

  # ========================================================================= #
  # === Gtk::FlexibleVte.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = ::Gtk::FlexibleVte.new(i)
    _.infer_the_size_automatically
    r = ::Gtk.run
    r << _
    r.automatic_size
    r.automatic_title
    r.alt_shortcut('1') { 'focus_on_tab_number(1)' }
    r.alt_shortcut('2') { 'focus_on_tab_number(2)' }
    r.alt_shortcut('3') { 'focus_on_tab_number(3)' }
    r.alt_shortcut('4') { 'focus_on_tab_number(4)' }
    r.alt_shortcut('5') { 'focus_on_tab_number(5)' }
    r.alt_shortcut('6') { 'focus_on_tab_number(6)' }
    r.alt_shortcut('7') { 'focus_on_tab_number(7)' }
    r.alt_shortcut('8') { 'focus_on_tab_number(8)' }
    r.alt_shortcut('9') { 'focus_on_tab_number(9)' }
    r.top_left_then_run
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::FlexibleVte.run
end