#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::ImageCloseOnClickAction
# =========================================================================== #
# require 'gtk_paradise/widgets/gtk3/image_close_on_click_action/image_close_on_click_action.rb'
# Gtk::ImageCloseOnClickAction.new(ARGV)
# =========================================================================== #
require 'gtk_paradise/requires/require_gtk3'

module Gtk

class ImageCloseOnClickAction < ::Gtk::Box # === Gtk::ImageCloseOnClickAction

  require 'gtk_paradise/base_module/base_module.rb'
  include ::Gtk::BaseModule

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Image close on click action'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = '25% or minimum 200px'

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = '15% or minimum 100px'

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = :dejavu_condensed_20

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      use_this_image = ARGV,
      run_already    = true
    )
    super(:vertical)
    reset
    set_use_this_image(use_this_image)
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    infer_the_namespace
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, namespace?]
    # ======================================================================= #
    # === Set the title, width, height and the font in use.
    # ======================================================================= #
    title_width_height_font(TITLE, WIDTH, HEIGHT, USE_THIS_FONT)
    use_gtk_paradise_project_css_file # or use use_project_css_file 
    infer_the_size_automatically
    # ======================================================================= #
    # === @parent_widget
    # ======================================================================= #
    @parent_widget = nil
  end

  # ========================================================================= #
  # === set_parent_widget
  # ========================================================================= #
  def set_parent_widget(i)
    @parent_widget = i
  end

  # ========================================================================= #
  # === set_use_this_image
  # ========================================================================= #
  def set_use_this_image(i)
    if i.is_a? Array
      i = i.first
    end
    @use_this_image = i
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    image = gtk_image(@use_this_image)
    image.bblack1
    event_box = gtk_event_box(image)
    event_box.on_click {
      do_close
    }
    event_box.pad2px
    event_box.hint = 'Click to close this widget again.'
    maximal(event_box, 2)
  end

  # ========================================================================= #
  # === do_close
  # ========================================================================= #
  def do_close
    destroy
    @parent_widget.destroy if @parent_widget
  end

  # ========================================================================= #
  # === Gtk::ImageCloseOnClickAction.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    r = Gtk.run
    image_close_on_click_action = Gtk::ImageCloseOnClickAction.new(i)
    image_close_on_click_action.set_parent_widget(r)
    r << image_close_on_click_action
    r.move(1220, 60)
    r.run
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::ImageCloseOnClickAction.run(ARGV)
end # image_close_on_click_action $RUBY_SRC/rpg_paradise/lib/rpg_paradise/images/gamebooks/13_stern_der_schmuggler/249.jpg