#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::HarddiscInformation
# =========================================================================== #
# require 'gtk_paradise/widgets/gtk3/information_about_the_harddisc/harddisc_information.rb'
# Gtk::HarddiscInformation.new
# =========================================================================== #
module Gtk

class HarddiscInformation # === Gtk::HarddiscInformation

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Information about the harddisc'

  # ========================================================================= #
  # === COMMAND_TO_RUN_FOR_QUERYING_INFORMATION_ABOUT_THE_LOCAL_FILESYSTEM
  # ========================================================================= #
  COMMAND_TO_RUN_FOR_QUERYING_INFORMATION_ABOUT_THE_LOCAL_FILESYSTEM = 'df -T -ah'

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      run_already = true
    )
    reset
    run if run_already
  end

  # ======================================================================== #
  # === reset
  # ======================================================================== #
  def reset
    infer_the_namespace
  end

  # ========================================================================= #
  # === available_mount_points
  # ========================================================================= #
  def available_mount_points
    @available_mount_points
  end

  # ========================================================================= #
  # === file_system?
  # ========================================================================= #
  def file_system?
    @file_system
  end

  # ========================================================================= #
  # === n_hdd?
  # ========================================================================= #
  def n_hdd?
    @n_hdd
  end

  # ========================================================================= #
  # === mounted_on?
  # ========================================================================= #
  def mounted_on?
    @mounted_on
  end

  # ========================================================================= #
  # === which_device_type?
  # ========================================================================= #
  def which_device_type?
    @which_device_type
  end

  # ========================================================================= #
  # === total_hdd_size?
  # ========================================================================= #
  def total_hdd_size?
    @total_hdd_size
  end

  # ========================================================================= #
  # === used_size?
  # ========================================================================= #
  def used_size?
    @used_size
  end

  # ========================================================================= #
  # === percentage_used?
  # ========================================================================= #
  def percentage_used?(
      cmd_to_use = COMMAND_TO_RUN_FOR_QUERYING_INFORMATION_ABOUT_THE_LOCAL_FILESYSTEM
    )
    _ = `#{cmd_to_use}`
    splitted = _.strip.split("\n")
    scanned = splitted.select {|entry|
      entry.start_with?('/dev/root') or entry.end_with?(" /\n")
    }.flatten
    first = scanned.first
    if first
      _ = first.split(' ')
      percentage_used = _[5]
      result = percentage_used.to_s.delete('%').to_f
      return result
    else
      return 0
    end
  end

  # ========================================================================= #
  # === update_dataset
  # ========================================================================= #
  def update_dataset
    result = `#{COMMAND_TO_RUN_FOR_QUERYING_INFORMATION_ABOUT_THE_LOCAL_FILESYSTEM}`
    # ======================================================================= #
    # The result will be like this:
    #
    #   Filesystem     Type      Size  Used Avail Use% Mounted on
    #   /dev/root      ext4      2.7T  585G  2.0T  23% /
    #
    # ======================================================================= #
    splitted = result.split("\n").
               select {|entry| entry.start_with?('/dev/') }
    @n_hdd = splitted.size # <- This is not quite correct, but has to suffice for now.
    # Select the highest entry for now:
    inner_splitted = splitted.map {|entry|
      entry.split(' ')
    }
    sorted = inner_splitted.sort_by {|entry|
      entry[2].delete('MT').to_f
    }
    max = sorted.first
    splitted = max
    if splitted
      @file_system       = splitted[1]
      @mounted_on        = splitted[6]
      @which_device_type = splitted[0]
      @total_hdd_size    = splitted[2]
      @percentage_used   = splitted[5]
      @used_size         = splitted[3]
      @available_mount_points = [@mounted_on]
    end
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    update_dataset
  end

end; end

if __FILE__ == $PROGRAM_NAME
  alias e puts
  _ = Gtk::HarddiscInformation.new
  pp _
  e 'The filesystem in use is: '+_.file_system?.to_s
end