#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::NotebookController
# =========================================================================== #
# require 'foobar/gui/gtk3/gtk3_standalone/gtk3_standalone.rb'
# Gtk::NotebookController.run
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class NotebookController < ::Gtk::Box # === Gtk::NotebookController 

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Notebook-Controller' 

  # ========================================================================= #
  # Next come the default height and width of the sys-launcher, also
  # called "admin_panel" these days, and called "control_panel" since
  # as of the year 2021. Then it was renamed again, into
  # "notebook_controller".
  # ========================================================================= #

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = '55% or minimum 1380px'

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = '50% or minimum 1000px'

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = :dejavu_condensed_22

  # ========================================================================= #
  # === PATH_TO_GTK_PARADISE
  # ========================================================================= #
  PATH_TO_GTK_PARADISE = 'gtk_paradise/widgets/gtk3/'

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = ARGV,
      run_already           = true
    )
    super(:vertical)
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables_as_well_as_the_internal_hash
    infer_the_namespace
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, namespace?]
    # ======================================================================= #
    # === Set the title, width, height and the font in use.
    # ======================================================================= #
    title_width_height_font(TITLE, WIDTH, HEIGHT, USE_THIS_FONT)
    upon_delete_event_quit_the_application
    use_gtk_paradise_project_css_file 
    infer_the_size_automatically
    # ======================================================================= #
    # === @file_control_panel
    #
    # See: bl $GTK_PARADISE/yaml/notebook_controller.yml
    # ======================================================================= #
    @file_control_panel = "#{Gtk.project_yaml_directory?}notebook_controller.yml"
    # ======================================================================= #
    # === @dataset
    # ======================================================================= #
    @dataset = nil
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    4
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    2
  end

  # ========================================================================= #
  # === try_to_load_the_yaml_file
  # ========================================================================= #
  def try_to_load_the_yaml_file(
      i = @file_control_panel
    )
    if File.exist? i
      @dataset = YAML.load_file(i)
    end
  end

  # ========================================================================= #
  # === focus_entry
  # ========================================================================= #
  def focus_entry(i = 0)
    @notebook.focus_on_this_tab(i.to_i)
  end

  # ========================================================================= #
  # === handle_middle_mouse_button_click_event
  #
  # This method will handle the event when the user presses the middle
  # mouse button.
  # ========================================================================= #
  def handle_middle_mouse_button_click_event
    signal_connect(:event) { |widget, event|
      # ===================================================================== #
      # The user pressed the middle mouse button here. For now this
      # means that the user wants to get rid of the tab; in the future
      # we may modify this behaviour, but for now this has to suffice.
      # ===================================================================== #
      if is_middle_mouse_button_click_event?(event)
        current_tab = @notebook.page
        @notebook.remove_page(current_tab)
      end
    }
  end

  # ========================================================================= #
  # === create_skeleton                            (create tag, skeleton tag)
  # ========================================================================= #
  def create_skeleton
  end

  # ========================================================================= #
  # === grab_application
  #
  # Use this to grab the application. This is mostly legacy code only,
  # though.
  # ========================================================================= #
  def grab_application
    Gtk.grab_add(self)
    Gdk.pointer_grab(self.window, 
      true, Gdk::Event::BUTTON_PRESS_MASK, self.window, 
      Gdk::Cursor.new(Gdk::Cursor::FLEUR),
      Gdk::Event::CURRENT_TIME)
  end

  # ========================================================================= #
  # === add_the_components
  #
  # This method will add the individual components onto the main
  # gtk-notebook widget.
  # ========================================================================= #
  def add_the_components
    # === @notebook
    @notebook = gtk_notebook
    @notebook.focus_on_the_first_tab
    @notebook.do_show_the_tabs
    @notebook.do_show_the_border
    @notebook.the_tabs_appear_on_top
    @notebook.is_scrollable
    @notebook.enable_popup = true
    @dataset.each_pair {|file_that_is_to_be_required, widget_namespace|
      # ===================================================================== #
      # The entries may look like this:
      #
      #   "wget_wrapper"=>"Gtk::WgetWrapper"
      #
      # ===================================================================== #
      # ===================================================================== #
      # The next case-when menu is used to sanitize some "shortcuts".
      # That way we do not have to hardcode it into the .yml file,
      # but could still do so if we'd like to.
      # ===================================================================== #
      case file_that_is_to_be_required # case tag
      # ===================================================================== #
      # === wetter_app
      # ===================================================================== #
      when /wetter(_|-)?app/
        file_that_is_to_be_required = 'chemistry_paradise/gui/gtk3/wetter/wetter.rb'
      # ===================================================================== #
      # === ask_exam_question
      # ===================================================================== #
      when 'ask_exam_question'
        file_that_is_to_be_required = 'studium/gui/gtk3/ask_exam_question/ask_exam_question.rb'
      # ===================================================================== #
      # === shell
      # ===================================================================== #
      when 'shell'
        file_that_is_to_be_required = 'roebe/gui/gtk3/shell/shell.rb'
      # ===================================================================== #
      # === my_calendar
      # ===================================================================== #
      when 'my_calendar'
        file_that_is_to_be_required = 'gtk_paradise/widgets/gtk3/my_calendar/my_calendar.rb'
      # ===================================================================== #
      # === tabble
      # ===================================================================== #
      when 'application_menu',
           'tabble'
        file_that_is_to_be_required = 'gtk_paradise/widgets/gtk3/application_menu/application_menu.rb'
      # ===================================================================== #
      # === Custom entries
      # ===================================================================== #
      when 'show_icon_theme',
           'select_file',
           'lspci',
           'vote_box_widget',
           'user',
           'google_searcher',
           'flip_state_widget',
           'contacts',
           'colour_filled_widget',
           'unicode_clock',
           'emoji_toggle_widget',
           'sys_message',
           'random_image',
           'editor',
           'coloured_bar',
           'cdripper',
           'maximize_button',
           'pid_displayer',
           'list_store_table3',
           'psaux_viewer',
           'directory_content_widget',
           'tabby',
           'simple_clock',
           'burning_widget',
           'wget_wrapper',
           'mini_clock',
           'coloured_square',
           'emoji_widget',
           'stopwatch',
           'lsmod',
           'conky'
           # 'file_viewer' 
        file_that_is_to_be_required = PATH_TO_GTK_PARADISE+
                                      file_that_is_to_be_required+'/'+
                                      file_that_is_to_be_required+'.rb'
      end
      if file_that_is_to_be_required
        begin
          require file_that_is_to_be_required
          _ = eval(widget_namespace).new
          use_this_title = File.basename(
            file_that_is_to_be_required
          ).sub(
            /#{File.extname(file_that_is_to_be_required)}$/,''
          )
          if _.respond_to?(:title?) and _.title? and
            !_.title?.empty?
            use_this_title = _.title?.to_s
          end
          # =================================================================== #
          # Finally append that widget onto the notebook.
          # =================================================================== #
          @notebook.append_this_widget(_, use_this_title)
        rescue LoadError => error
          pp error
          e 'Unavailable: '+
            sfile(file_that_is_to_be_required)
        end
      end
    }
    add_the_notebook
  end

  # ========================================================================= #
  # === add_the_notebook
  # ========================================================================= #
  def add_the_notebook
    add(@notebook)
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    abort_on_exception
    add_the_components
    handle_middle_mouse_button_click_event
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    try_to_load_the_yaml_file
    create_skeleton_then_connect_skeleton
  end

  # ========================================================================= #
  # === Gtk::NotebookController[]
  # ========================================================================= #
  def self.[](i = ARGV)
    new(i)
  end

  # ========================================================================= #
  # === Gtk::NotebookController.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = ::Gtk::NotebookController.new(i)
    r = ::Gtk.run
    r << _
    # ======================================================================= #
    # Next we will add several alt+key shortcuts.
    # ======================================================================= #
    r.alt_shortcut(1, 'focus_entry(0)')
    r.alt_shortcut(2, 'focus_entry(1)')
    r.alt_shortcut(3, 'focus_entry(2)')
    r.alt_shortcut(4, 'focus_entry(3)')
    r.alt_shortcut(5, 'focus_entry(4)')
    r.alt_shortcut(6, 'focus_entry(5)')
    r.alt_shortcut(7, 'focus_entry(6)')
    r.alt_shortcut(8, 'focus_entry(7)')
    r.alt_shortcut(9, 'focus_entry(8)')
    r.automatic
    r.top_left_then_run
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::NotebookController.run
end # controlpanel