#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::ViewWebpage
# =========================================================================== #
# require 'gtk_paradise/widgets/gtk3/view_webpage/view_webpage.rb'
# Gtk::ViewWebpage.run
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class ViewWebpage < ::Gtk::BaseModuleBox # === Gtk::ViewWebpage 

  require 'open-uri'
  begin
    require 'save_file'
  rescue LoadError; end

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'View Webpage'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = '55% or minimum 1000px'

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = '35% or minimum 400px'

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = :dejavu_condensed_20

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = ARGV,
      run_already           = true
    )
    super(:vertical)
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    infer_the_namespace
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, namespace?]
    title_width_height_font(TITLE, WIDTH, HEIGHT, USE_THIS_FONT)
    use_gtk_paradise_project_css_file 
    infer_the_size_automatically
    # ======================================================================= #
    # === @remote_URL
    #
    # This variable will eventually contain the remote URL that the user
    # wants to display.
    # ======================================================================= #
    @remote_URL = nil
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    4
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    2
  end

  # ========================================================================= #
  # === create_skeleton                                          (create tag)
  # ========================================================================= #
  def create_skeleton
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    abort_on_exception
    minimal(left_aligned_label('Enter the remote URL:'), 2)
    entry = create_entry
    entry.align_to_the_center
    entry.bblack2
    entry.yellow_background
    entry.on_enter {
      @remote_URL = entry.text?
      @remote_URL.prepend('https://www.') unless @remote_URL.start_with?('https://www.')
      do_download_into_a_local_page
    }
    minimal(entry, 2)
    @text_view = gtk_text_view
    @text_view.bblack1
    @text_view.pad5px
    @text_view.mar5px
    @text_view.use_this_font = :hack_9
    @text_view.wrap_mode_word
    scrolled_window = gtk_scrolled_window(@text_view) { :always }
    scrolled_window.width_height(550, 920)
    minimal(scrolled_window, 4)
  end

  # ========================================================================= #
  # === do_download_into_a_local_page
  # ========================================================================= #
  def do_download_into_a_local_page
    if @remote_URL
      begin
        dataset = URI.open(@remote_URL).read
        into = '/home/Temp/foobar.html'
        SaveFile.write_what_into(dataset, into)
        @text_view.set_text(dataset.to_s)
      rescue Exception => error
        pp error
      end
    end
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    create_skeleton_then_connect_skeleton
  end

  # ========================================================================= #
  # === Gtk::ViewWebpage.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = ::Gtk::ViewWebpage.new(i)
    r = ::Gtk.run
    r << _
    r.automatic_size_then_automatic_title
    r.enable_quick_exit
    r.top_left_then_run
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::ViewWebpage.run
end