#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::DebugWidgetModule
# =========================================================================== #
# require 'gtk_paradise/widgets/shared_code/debug_widget/debug_widget_module.rb'
# include ::Gtk::DebugWidgetModule
# =========================================================================== #
module Gtk

module DebugWidgetModule

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  # ========================================================================= #
  # === NAMESPACE
  # ========================================================================= #
  NAMESPACE = inspect

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Debug-Widget'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = 1240

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = 440

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = :dejavu_condensed_20

  # ========================================================================= #
  # === SMALLER_FONT
  # ========================================================================= #
  SMALLER_FONT = :dejavu_condensed_15

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      optional_file = nil,
      run_already   = true
    )
    super()
    reset
    set_label_widget(
      gtk_hbox(image_computer, gtk_label(' Debug'))
    )
    run if run_already
  end

  # ========================================================================= #
  # === reset
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, NAMESPACE]
    # ======================================================================= #
    # === @title
    # ======================================================================= #
    @title  = TITLE
    # ======================================================================= #
    # === @width
    # ======================================================================= #
    set_width(WIDTH)
    # ======================================================================= #
    # === @height
    # ======================================================================= #
    set_height(HEIGHT)
    set_use_this_font(USE_THIS_FONT)
    use_gtk_paradise_css_file
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    0
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    0
  end

  # ========================================================================= #
  # === create_the_outer_vbox
  # ========================================================================= #
  def create_the_outer_vbox
    @outer_vbox = gtk_vbox
    @outer_vbox.set_border_width(8)
    @outer_vbox.show_all
  end

  # ========================================================================= #
  # === return_popup_menu
  #
  # This is mostly done for demonstration-purposes, to showcase how a
  # context-menu can be re-used in different ruby-gtk applications.
  # ========================================================================= #
  def return_popup_menu
    context_menu = gtk_menu
    context_menu.append(mitem1 = gtk_menu_item(label: 'Show the debug widget'))
    context_menu.show_all
    mitem1.signal_connect(:activate) { |widget|
      ::Gtk::DebugWidgetModule.run
    }
    return context_menu
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    @outer_vbox.extend(gtk_base_module)
    @outer_vbox.minimal(
      gtk_hbox(
        image_input_mouse,
        left_label(
          ' Showing potentially useful information about the '\
          'gtk-widget at hand:'
        )
      )
    )
    @outer_vbox.minimal(left_label('    <b>Resolution</b>: '+max_width?.to_s))
    @outer_vbox.minimal(left_label('    <b>Resolution</b>: '+max_height?.to_s))
    @outer_vbox.minimal(horizontal_spacer)
    @outer_vbox.minimal(horizontal_spacer)
    _ = configuration?
    _.each_with_index {|entry, index|
      @outer_vbox.minimal(
        case index
        when 0
          left_label(' Use a .config file? <b>'+entry.to_s+'</b>  ')
        when 1
          left_label(' Base directory: <b>'+entry.to_s+'</b>  ')
        else
          left_label(' <b>'+entry.to_s+'</b>  ')
        end
      )
    }
    # ======================================================================= #
    # Next, we will pass a location such as:
    #
    #   "/home/Programs/Ruby/3.0.2/lib/ruby/site_ruby/3.0.0/gtk_paradise/widgets/shared_code/debug_widget"
    #
    # to the following method.
    # ======================================================================= #
    mini_hbox = gtk_hbox
    mini_hbox.minimal(
      gtk_label('Path to the project.css file: ').align_to_the_left
    )
    selectable_label = gtk_label(
      '<b>gtk_paradise/css_files/project.css</b>'
    )
    # selectable_label.make_selectable # This, oddly enough,
    # selects the label at once.
    mini_hbox.maximal(selectable_label)
    @outer_vbox.minimal(mini_hbox)
    # ======================================================================= #
    # Create the show-CSS button next:
    # ======================================================================= #
    button_show_CSS = bold_button('Show the CSS in use')
    button_show_CSS.bblack2
    button_show_CSS.css_class('royalblue')
    button_show_CSS.css_class('BG_Black')
    button_show_CSS.css_class('pad5px')
    button_show_CSS.on_clicked {
      # ===================================================================== #
      # The button will be toggled on every click-action.
      # ===================================================================== #
      case button_show_CSS.text?
      when 'Show the CSS in use'
        button_show_CSS.text = 'Hide the CSS in use'
        button_show_CSS.make_bold
        do_show_the_CSS_in_use
        set_the_main_buffer_with_the_CSS_rules_in_use
      when 'Hide the CSS in use'
        button_show_CSS.text = 'Show the CSS in use'
        button_show_CSS.make_bold
        set_the_main_buffer_with_the_CSS_rules_in_use('')
      end
    }
    @outer_vbox.minimal(button_show_CSS,  4)
    @outer_vbox.minimal(@scrolled_window, 2)
    @alignment = gtk_alignment(0.05, 0.05, 0.05, 0.05)
    @alignment.add(@outer_vbox)
    add(@alignment)
  end

  # ========================================================================= #
  # === set_the_main_buffer_with_the_CSS_rules_in_use
  # ========================================================================= #
  def set_the_main_buffer_with_the_CSS_rules_in_use(
      i = css_rules?
    )
    @text_buffer.set_text(i.to_s)
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    create_skeleton_then_connect_skeleton
    do_style_the_scrollbar
  end

  # ========================================================================= #
  # === create_skeleton                                          (create tag)
  # ========================================================================= #
  def create_skeleton
    create_the_outer_vbox
    create_the_main_scrolled_window
  end

  # ========================================================================= #
  # === Gtk::DebugWidgetModule.run
  # ========================================================================= #
  def self.run
    require 'gtk_paradise/run'
    _ = ::Gtk::DebugWidget.new
    r = ::Gtk.run
    r.add_button_press_events
    r << _
    r.signal_connect(:button_press_event) { |widget, event|
      # ========================================================================= #
      # Note that 'menu' was defined above, as an instance of Gtk::Menu.
      # ========================================================================= #
      case event.button
      when 3 # right mouse click event.
        _.return_popup_menu.popup(
          nil, nil, event.button, event.time
        )
      end
    }
    r.automatic
    r.top_left_then_run
  end

  # ========================================================================= #
  # === create_the_main_scrolled_window
  # ========================================================================= #
  def create_the_main_scrolled_window
    @text_buffer = gtk_text_buffer 
    @text_view = gtk_text_view(@text_buffer)
    @text_view.clear_background
    @text_view.light_yellow_background
    @text_view.use_this_font(:hack_15)
    # ======================================================================= #
    # === @scrolled_window
    # ======================================================================= #
    hbox = gtk_hbox
    numbered_lines = return_numbered_lines_widget({ upper_range: 1000 })
    numbered_lines.use_this_font(:hack_15)
    hbox.minimal(numbered_lines)
    hbox.maximal(@text_view)
    @scrolled_window = gtk_scrolled_window(hbox) { :only_top_to_bottom }
    @scrolled_window.width_height(540, 400)
    @scrolled_window.use_this_font(:hack_20)
    @scrolled_window.clear_background
    @scrolled_window.set_name('fancy_scrollbar')
    @scrolled_window.css_class('pad5px')
    @scrolled_window.css_class('mar2px')
    @scrolled_window.bblack3
    @scrolled_window.use_this_font(SMALLER_FONT)
  end

  # ========================================================================= #
  # === do_style_the_scrollbar
  # ========================================================================= #
  def do_style_the_scrollbar
    more_css '
    #fancy_scrollbar slider {
  /* Size of the slider */
  min-width:      8px;
  min-height:    25px;
  border-radius:  8px;

  /* Border around the slider */
  border: 4px solid steelblue;
}

#fancy_scrollbar trough {
  background-color: transparent;
  background-repeat: no-repeat;
  background-position: center;
}
'
    apply_the_CSS_rules
  end

end; end