#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::FlipStateWidgetModule
#
# This widget can accept a hash containing key-value true-false pairs.
# This hash is then used to display toggle-buttons, aka Gtk::Switch
# entries. The idea here is that a .yml file can be used as input,
# quickly providing some user choice, as-is.
#
# Todo:
#
# - We still must implemented .yml loading and saving into a 
#   yaml file. Continue on load_this_yaml_file().
#
# =========================================================================== #
# require 'gtk_paradise/widgets/shared_code/flip_state_widget/flip_state_widget_module.rb'
# include ::Gtk::FlipStateWidgetModule
# =========================================================================== #
module Gtk

module FlipStateWidgetModule

  require 'yaml'

  include ::Gtk::BaseModule

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Flip State Widget'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = 80

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = 80

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      optional_file = nil,
      run_already   = true
    )
    super(:vertical)
    reset
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    infer_the_namespace
    set_use_this_font(:dejavu_condensed_22)
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, namespace?]
    title_width_height(TITLE, WIDTH, HEIGHT)
    # ======================================================================= #
    # === @input_hash
    # ======================================================================= #
    @input_hash = {
      Tom: true,
      Jerry: false,
      Spike: true
    }
    use_gtk_paradise_project_css_file
    infer_the_size_automatically
  end

  # ========================================================================= #
  # === load_this_yaml_file
  # ========================================================================= #
  def load_this_yaml_file(yaml_file)
    if File.exist? yaml_file
      _ = YAML.load_file(yaml_file)
      if _.is_a? Hash # Assign a new hash that way.
        @input_hash = _
      end
    end
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    2
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    2
  end

  # ========================================================================= #
  # === create_skeleton
  # ========================================================================= #
  def create_skeleton
    @grid = gtk_grid
    @grid.set_column_spacing(10)
  end

  # ========================================================================= #
  # === set_input_hash
  # ========================================================================= #
  def set_input_hash(i)
    @input_hash = i
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    abort_on_exception
    index = 0
    @input_hash.each_pair {|key, value|
      switch = gtk_switch
      # ===================================================================== #
      # Whether it is active:
      #
      #   _.state?
      #
      # ===================================================================== #
      switch.disallow_resizing
      switch.set_size_request(80, 30)
      case value
      when true
        switch.set_active(true)
      when false
        switch.set_active(false)
      end
      label = gtk_label(key.to_s)
      # ===================================================================== #
      # API for .attach() is:
      #   .attach(child, left, top, width, height)
      # ===================================================================== #
      @grid.attach(label,  0, 0+index, 1, 1)
      @grid.attach(switch, 1, 0+index, 1, 1)
      index += 1
    }
    @button_save = gtk_button('Save')
    @button_save.set_name('button1')
    @button_save.info(
      'Click this button in order to '\
      'save the dataset, if a .yml file '\
      'was used as input.'
    )
    @button_save.on_clicked {
e 'TODO: implement save functionality'
    }
    minimal(@grid, 1)
    minimal(@button_save, 1)
  end
    
  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    create_skeleton_then_connect_skeleton
  end

  # ========================================================================= #
  # === Gtk::FlipStateWidgetModule.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = ::Gtk::FlipStateWidget.new(i)
    r = ::Gtk.run
    r << _
    r.set_size_request(_.width?, _.height?)
    r.top_left_then_run
  end

end; end