#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::VoteBoxWidgetModule
#
# This small widget can be used as a "vote" widget. People can select
# and send/submit their selection.
# =========================================================================== #
# require 'gtk_paradise/widgets/shared_code/vote_box_widget/vote_box_widget_module.rb'
# include ::Gtk::VoteBoxWidgetModule
# =========================================================================== #
module Gtk

module VoteBoxWidgetModule

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  # ========================================================================= #
  # === NAMESPACE
  # ========================================================================= #
  NAMESPACE = inspect

  # ========================================================================= #
  # === TEST_ARRAY
  # ========================================================================= #
  TEST_ARRAY = [
    'choice 1 (Austria)',
    'choice 2 (Germany)',
    'choice 3 (Japan)',
    'choice 4 (USA)',
    'choice 5 (France)',
    'choice 6 (Italy)',
    'choice 7 (South Africa)',
    'choice 8 (Taiwan)'
  ]

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Vote Box Widget'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = 1200

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = 500

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      optional_file = nil,
      run_already   = true
    )
    super(:vertical)
    reset
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, NAMESPACE]
    # ======================================================================= #
    # === @title
    # ======================================================================= #
    @title  = TITLE
    # ======================================================================= #
    # === @width
    # ======================================================================= #
    set_width(WIDTH)
    # ======================================================================= #
    # === @height
    # ======================================================================= #
    set_height(HEIGHT)
    # ======================================================================= #
    # === @last_choice_made
    #
    # We will store the choice made in this instance variable.
    # ======================================================================= #
    @last_choice_made = nil
    # ======================================================================= #
    # === @input_array
    # ======================================================================= #
    @input_array = TEST_ARRAY
    @use_this_font = :hack_20 # :dejavu_condensed_20
    set_use_this_font(@use_this_font)
    use_gtk_paradise_project_css_file
    infer_the_size_automatically
  end

  # ========================================================================= #
  # === set_input_array
  # ========================================================================= #
  def set_input_array(i)
    @input_array = [i].flatten.compact
  end; alias update set_input_array # === update

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    0
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    0
  end

  # ========================================================================= #
  # === create_skeleton
  # ========================================================================= #
  def create_skeleton
    create_buttons
  end

  # ========================================================================= #
  # === create_buttons
  # ========================================================================= #
  def create_buttons
    @send_button = bold_button('_Send')
    @send_button.css('bblack2')
    @send_button.set_name('button1')
    @send_button.disallow_resizing
    @send_button.set_size_request(80, 30)
    @send_button.fancy_tooltips =
      'Click this button to submit your selection made.'
    @send_button.on_clicked {
      determine_the_current_selection
    }
  end

  # ========================================================================= #
  # === determine_the_current_selection
  # ========================================================================= #
  def determine_the_current_selection
    selection = ''.dup
    @array_radio_buttons.each {|button|
      if button.active?
        selection << button.label
      end
    }
    @last_choice_made = selection # Keep track of the last choice that was made.
    e 'Selected radio button is: '+selection
  end

  # ========================================================================= #
  # === last_choice_made?
  # ========================================================================= #
  def last_choice_made?
    @last_choice_made
  end; alias selection? last_choice_made? # === selection?

  # ========================================================================= #
  # === assign_to_vbox_and_array_radio_buttons
  #
  # We can modify @array_radio_buttons lateron, if necessary.
  # ========================================================================= #
  def assign_to_vbox_and_array_radio_buttons
    @vbox, @array_radio_buttons = options(@input_array)
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    Thread.abort_on_exception = true
    assign_to_vbox_and_array_radio_buttons
    minimal(@vbox)
    minimal(@send_button, 2)
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    create_skeleton_then_connect_skeleton
  end

  # ========================================================================= #
  # === Gtk::VoteBoxWidgetModule.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = ::Gtk::VoteBoxWidget.new(i)
    r = ::Gtk.run
    r << _
    r.automatic
    r.top_left_then_run
  end

end; end