#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This file here is a test-widget, not unlike the files under experimental/
# but more dedicated to testing existing functionality as-is, rather than
# testing new ideas.
# =========================================================================== #
# require 'gtk_paradise/test/test_widget.rb'
# =========================================================================== #
require 'gtk_paradise/require_gtk3'
require 'gtk_paradise/run'

class TestWidget < ::Gtk::Box

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  # ========================================================================= #
  # === NAMESPACE
  # ========================================================================= #
  NAMESPACE = inspect

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      run_already = true
    )
    super(:vertical)
    reset
    run if run_already
  end

  # ========================================================================= #
  # === reset
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, NAMESPACE]
    set_border_width(0) if respond_to? :set_border_width
    set_font(:hack_22)
    use_gtk_paradise_project_css_file
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    minimal(
      div {
        sbr('Hi there 1')
      }
    )
    minimal(
      div {
        sbr('Hi there 2')
      }
    )
    minimal(
      div {
        sbr(::Gtk.return_path_to_the_default_css_file)
      }
    )
    minimal(
      div {
        sbr('Does the file exist? '+File.exist?(::Gtk.return_path_to_the_default_css_file).to_s)
      }
    )
    minimal(
      div {
        sbr 'The default css file is (this is disabled now).'
      }
    )
    # Next add a test-label with a hyperlink.
    big_label = gtk_label(
      'Hello at <a href="http://www.google.at/">google</a>.'
    )
    big_label.parse_hyperlinks
    minimal(big_label, 20)
    # Next, create a textView widget.
    @text_buffer = gtk_text_buffer
    @text_view = gtk_text_view(@text_buffer)
    @text_view.on_button_release_event {
      parse_for_URL(@text_buffer.text)
    }
    scrolled_window = always_scrolled_window(@text_view)
    maximal(scrolled_window)
    label_margin_test = gtk_label('Testing side margins here via CSS.')
    label_margin_test.set_name('mars1em')
    add(label_margin_test)
    label_margin_no_test = gtk_label('Testing side margins here without CSS.')
    add(label_margin_no_test)
  end

  # ========================================================================= #
  # === parse_for_URL
  # ========================================================================= #
  def parse_for_URL(i = @text_buffer.text)
    e 'Parsing for URls...'
  end

end

if __FILE__ == $PROGRAM_NAME
  _ = TestWidget.new
  r = Gtk.run
  r << _
  r.show_all
  r.set_border_width(15)
  r.top_left_then_run
end